/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.hydrogenatom.dialog;

import edu.colorado.phet.common.phetcommon.application.PaintImmediateDialog;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.dialogs.ColorChooserFactory;
import edu.colorado.phet.common.phetcommon.view.HorizontalLayoutPanel;
import edu.colorado.phet.common.phetcommon.view.PhetFrame;
import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.common.phetcommon.view.util.EasyGridBagLayout;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import edu.colorado.phet.hydrogenatom.control.SpinnerControl;
import edu.colorado.phet.hydrogenatom.energydiagrams.AbstractEnergyDiagram;
import edu.colorado.phet.hydrogenatom.hacks.GunWavelengthControl;
import edu.colorado.phet.hydrogenatom.hacks.MetastableHandler;
import edu.colorado.phet.hydrogenatom.model.AbstractHydrogenAtom;
import edu.colorado.phet.hydrogenatom.model.BohrModel;
import edu.colorado.phet.hydrogenatom.model.Gun;
import edu.colorado.phet.hydrogenatom.model.RutherfordScattering;
import edu.colorado.phet.hydrogenatom.module.HAModule;
import edu.colorado.phet.hydrogenatom.view.atom.DeBroglieBrightnessMagnitudeNode;
import edu.colorado.phet.hydrogenatom.view.atom.DeBroglieBrightnessNode;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DeveloperControlsDialog
extends PaintImmediateDialog
implements ColorChooserFactory.Listener {
    private static final Insets DEFAULT_INSETS = new Insets(3, 3, 3, 3);
    private static final Stroke COLOR_CHIP_STROKE = new BasicStroke(1.0f);
    private static final Color COLOR_CHIP_BORDER_COLOR = Color.BLACK;
    private static final Color TITLE_COLOR = Color.RED;
    private static final Font TITLE_FONT = new PhetFont(1, 14);
    private HAModule _module;
    private SpinnerControl _maxParticlesSpinner;
    private SpinnerControl _absorptionClosenessSpinner;
    private JCheckBox _rutherfordScatteringOutputCheckBox;
    private SpinnerControl _wavelengthHiliteThreshold;
    private JCheckBox _absorptionCheckBox;
    private JCheckBox _spontanuousEmissionCheckBox;
    private JCheckBox _stimulatedEmissionCheckBox;
    private SpinnerControl _minStateTimeSpinner;
    private ColorChip _deBroglieBrightnessMagnitudePlusChip;
    private ColorChip _deBroglieBrightnessMagnitudeZeroChip;
    private ColorChip _deBroglieBrightnessPlusChip;
    private ColorChip _deBroglieBrightnessMinusChip;
    private ColorChip _deBroglieBrightnessZeroChip;
    private SpinnerControl _metastableTimeSpinner;
    private SpinnerControl _squiggleLifetimeSpinner;
    private JDialog _colorChooserDialog;
    private ColorChip _editColorChip;

    public DeveloperControlsDialog(Frame frame, HAModule hAModule) {
        super(frame, "Developer Controls");
        this.setResizable(false);
        this._module = hAModule;
        JPanel jPanel = this.createInputPanel();
        VerticalLayoutPanel verticalLayoutPanel = new VerticalLayoutPanel();
        verticalLayoutPanel.setFillHorizontal();
        verticalLayoutPanel.add(jPanel);
        this.setContentPane(verticalLayoutPanel);
        this.pack();
        SwingUtils.centerDialogInParent(this);
    }

    private JPanel createInputPanel() {
        int n = this._module.getGun().getMaxParticles();
        boolean bl = true;
        int n2 = 100;
        boolean bl2 = true;
        int n3 = 3;
        Object object = "Max particles in box:";
        String string = "";
        this._maxParticlesSpinner = new SpinnerControl(n, (double)bl, n2, (double)bl2, n3, (String)object, string);
        this._maxParticlesSpinner.setEditable(false);
        double d = AbstractHydrogenAtom.COLLISION_CLOSENESS;
        double d2 = 1.0;
        double d3 = d * 4.0;
        double d4 = 0.5;
        int n4 = 3;
        String string2 = "Photon absorbed when this close:";
        String string3 = "";
        this._absorptionClosenessSpinner = new SpinnerControl(d, d2, d3, d4, n4, string2, string3);
        this._absorptionClosenessSpinner.setEditable(false);
        this._rutherfordScatteringOutputCheckBox = new JCheckBox("Rutherford Scattering debug output", RutherfordScattering.DEBUG_OUTPUT_ENABLED);
        int n5 = GunWavelengthControl.KNOB_HILITE_THRESHOLD;
        bl = true;
        int n6 = 20;
        bl2 = true;
        int n7 = 3;
        object = "<html>Wavelength slider hilites when knob is<br>this close to a transition wavelength:</html>";
        String string4 = "ns";
        this._wavelengthHiliteThreshold = new SpinnerControl(n5, (double)bl, n6, (double)bl2, n7, (String)object, string4);
        this._wavelengthHiliteThreshold.setEditable(false);
        this._absorptionCheckBox = new JCheckBox("absorption enabled", BohrModel.DEBUG_ABSORPTION_ENABLED);
        this._spontanuousEmissionCheckBox = new JCheckBox("spontaneous emission enabled", BohrModel.DEBUG_SPONTANEOUS_EMISSION_ENABLED);
        this._stimulatedEmissionCheckBox = new JCheckBox("stimulated emission enabled", BohrModel.DEBUG_STIMULATED_EMISSION_ENABLED);
        n5 = BohrModel.MIN_TIME_IN_STATE;
        bl = true;
        n6 = 300;
        bl2 = true;
        n7 = 4;
        object = "<html>Min time that electron must spend<br>in a state before it can emit a photon:</html>";
        string4 = "dt";
        this._minStateTimeSpinner = new SpinnerControl(n5, (double)bl, n6, (double)bl2, n7, (String)object, string4);
        this._minStateTimeSpinner.setEditable(false);
        HorizontalLayoutPanel horizontalLayoutPanel = new HorizontalLayoutPanel();
        JComponent jComponent = new JLabel("Brightness magnitude colors:");
        JLabel jLabel = new JLabel("1=");
        JComponent jComponent2 = new JLabel("0=");
        this._deBroglieBrightnessMagnitudePlusChip = new ColorChip();
        this.setColor(this._deBroglieBrightnessMagnitudePlusChip, DeBroglieBrightnessMagnitudeNode.MAX_COLOR);
        this._deBroglieBrightnessMagnitudeZeroChip = new ColorChip();
        this.setColor(this._deBroglieBrightnessMagnitudeZeroChip, DeBroglieBrightnessMagnitudeNode.MIN_COLOR);
        horizontalLayoutPanel.setInsets(DEFAULT_INSETS);
        horizontalLayoutPanel.add(jComponent);
        horizontalLayoutPanel.add(jLabel);
        horizontalLayoutPanel.add(this._deBroglieBrightnessMagnitudePlusChip);
        horizontalLayoutPanel.add(jComponent2);
        horizontalLayoutPanel.add(this._deBroglieBrightnessMagnitudeZeroChip);
        jComponent = new HorizontalLayoutPanel();
        jLabel = new JLabel("Brightness colors:");
        jComponent2 = new JLabel("+1=");
        JLabel jLabel2 = new JLabel("0=");
        object = new JLabel("-1=");
        this._deBroglieBrightnessPlusChip = new ColorChip();
        this.setColor(this._deBroglieBrightnessPlusChip, DeBroglieBrightnessNode.PLUS_COLOR);
        this._deBroglieBrightnessZeroChip = new ColorChip();
        this.setColor(this._deBroglieBrightnessZeroChip, DeBroglieBrightnessNode.ZERO_COLOR);
        this._deBroglieBrightnessMinusChip = new ColorChip();
        this.setColor(this._deBroglieBrightnessMinusChip, DeBroglieBrightnessNode.MINUS_COLOR);
        ((HorizontalLayoutPanel)jComponent).setInsets(new Insets(5, 5, 5, 5));
        ((HorizontalLayoutPanel)jComponent).add(jLabel);
        ((HorizontalLayoutPanel)jComponent).add(jComponent2);
        ((HorizontalLayoutPanel)jComponent).add(this._deBroglieBrightnessPlusChip);
        ((HorizontalLayoutPanel)jComponent).add(jLabel2);
        ((HorizontalLayoutPanel)jComponent).add(this._deBroglieBrightnessZeroChip);
        ((HorizontalLayoutPanel)jComponent).add((Component)object);
        ((HorizontalLayoutPanel)jComponent).add(this._deBroglieBrightnessMinusChip);
        double d5 = MetastableHandler.MAX_STUCK_TIME;
        int n8 = 50;
        int n9 = 500;
        boolean bl3 = true;
        int n10 = 3;
        String string5 = "<html>Max time in metastable state<br>before firing absorbable photon:<html>";
        string2 = "dt";
        this._metastableTimeSpinner = new SpinnerControl(d5, n8, n9, (double)bl3, n10, string5, string2);
        this._metastableTimeSpinner.setEditable(false);
        d5 = AbstractEnergyDiagram.SQUIGGLE_LIFETIME / 1000.0;
        double d6 = 0.1;
        double d7 = 5.0;
        double d8 = 0.1;
        int n11 = 3;
        String string6 = "Squiggles disappear after";
        String string7 = "sec";
        this._squiggleLifetimeSpinner = new SpinnerControl(d5, d6, d7, d8, n11, string6, string7);
        this._squiggleLifetimeSpinner.setEditable(false);
        EventListener eventListener = new EventListener();
        this._maxParticlesSpinner.getSpinner().addChangeListener(eventListener);
        this._absorptionClosenessSpinner.getSpinner().addChangeListener(eventListener);
        this._rutherfordScatteringOutputCheckBox.addChangeListener(eventListener);
        this._wavelengthHiliteThreshold.getSpinner().addChangeListener(eventListener);
        this._absorptionCheckBox.addChangeListener(eventListener);
        this._spontanuousEmissionCheckBox.addChangeListener(eventListener);
        this._stimulatedEmissionCheckBox.addChangeListener(eventListener);
        this._minStateTimeSpinner.getSpinner().addChangeListener(eventListener);
        this._deBroglieBrightnessMagnitudePlusChip.addMouseListener(eventListener);
        this._deBroglieBrightnessMagnitudeZeroChip.addMouseListener(eventListener);
        this._deBroglieBrightnessPlusChip.addMouseListener(eventListener);
        this._deBroglieBrightnessZeroChip.addMouseListener(eventListener);
        this._deBroglieBrightnessMinusChip.addMouseListener(eventListener);
        this._metastableTimeSpinner.getSpinner().addChangeListener(eventListener);
        this._squiggleLifetimeSpinner.getSpinner().addChangeListener(eventListener);
        jComponent2 = new JPanel();
        jComponent2.setBorder(new EmptyBorder(5, 5, 5, 5));
        EasyGridBagLayout easyGridBagLayout = new EasyGridBagLayout((JPanel)jComponent2);
        easyGridBagLayout.setInsets(new Insets(3, 5, 3, 5));
        jComponent2.setLayout(easyGridBagLayout);
        n9 = 0;
        easyGridBagLayout.addComponent(new TitleLabel("Global:"), n9++, 0);
        easyGridBagLayout.addComponent(this._maxParticlesSpinner, n9++, 0);
        easyGridBagLayout.addComponent(this._absorptionClosenessSpinner, n9++, 0);
        easyGridBagLayout.addComponent(this._rutherfordScatteringOutputCheckBox, n9++, 0);
        easyGridBagLayout.addComponent(this._wavelengthHiliteThreshold, n9++, 0);
        easyGridBagLayout.addFilledComponent(new JSeparator(), n9++, 0, 2);
        easyGridBagLayout.addComponent(new TitleLabel("Bohr/deBroglie/Schr\u00f6dinger:"), n9++, 0);
        easyGridBagLayout.addComponent(this._absorptionCheckBox, n9++, 0);
        easyGridBagLayout.addComponent(this._spontanuousEmissionCheckBox, n9++, 0);
        easyGridBagLayout.addComponent(this._stimulatedEmissionCheckBox, n9++, 0);
        easyGridBagLayout.addComponent(this._minStateTimeSpinner, n9++, 0);
        easyGridBagLayout.addFilledComponent(new JSeparator(), n9++, 0, 2);
        easyGridBagLayout.addComponent(new TitleLabel("deBroglie:"), n9++, 0);
        easyGridBagLayout.addComponent(horizontalLayoutPanel, n9++, 0);
        easyGridBagLayout.addComponent(jComponent, n9++, 0);
        easyGridBagLayout.addFilledComponent(new JSeparator(), n9++, 0, 2);
        easyGridBagLayout.addComponent(new TitleLabel("Schr\u00f6dinger:"), n9++, 0);
        easyGridBagLayout.addComponent(this._metastableTimeSpinner, n9++, 0);
        easyGridBagLayout.addFilledComponent(new JSeparator(), n9++, 0, 2);
        easyGridBagLayout.addComponent(new TitleLabel("Energy diagrams:"), n9++, 0);
        easyGridBagLayout.addComponent(this._squiggleLifetimeSpinner, n9++, 0);
        return jComponent2;
    }

    private void setColor(ColorChip colorChip, Color color) {
        Rectangle rectangle = new Rectangle(0, 0, 15, 15);
        BufferedImage bufferedImage = new BufferedImage(rectangle.width, rectangle.height, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(color);
        graphics2D.fill(rectangle);
        graphics2D.setStroke(COLOR_CHIP_STROKE);
        graphics2D.setColor(COLOR_CHIP_BORDER_COLOR);
        graphics2D.draw(rectangle);
        colorChip.setIcon(new ImageIcon(bufferedImage));
    }

    private void handleMaxParticlesSpinner() {
        int n = this._maxParticlesSpinner.getIntValue();
        Gun gun = this._module.getGun();
        gun.setMaxParticles(n);
    }

    private void handleAbsorptionClosenessSpinner() {
        AbstractHydrogenAtom.COLLISION_CLOSENESS = this._absorptionClosenessSpinner.getDoubleValue();
    }

    private void handleRutherfordScatteringOutputCheckBox() {
        RutherfordScattering.DEBUG_OUTPUT_ENABLED = this._rutherfordScatteringOutputCheckBox.isSelected();
    }

    private void handleWavelengthHiliteThresholdSpinner() {
        GunWavelengthControl.KNOB_HILITE_THRESHOLD = this._wavelengthHiliteThreshold.getIntValue();
    }

    private void handleAbsorptionEmissionCheckBoxes() {
        BohrModel.DEBUG_ABSORPTION_ENABLED = this._absorptionCheckBox.isSelected();
        BohrModel.DEBUG_SPONTANEOUS_EMISSION_ENABLED = this._spontanuousEmissionCheckBox.isSelected();
        BohrModel.DEBUG_STIMULATED_EMISSION_ENABLED = this._stimulatedEmissionCheckBox.isSelected();
    }

    private void handleMinStateTime() {
        BohrModel.MIN_TIME_IN_STATE = this._minStateTimeSpinner.getIntValue();
    }

    private void handleMetastableTimeSpinner() {
        MetastableHandler.MAX_STUCK_TIME = this._metastableTimeSpinner.getDoubleValue();
    }

    private void handleSquiggleLifetimeSpinner() {
        AbstractEnergyDiagram.SQUIGGLE_LIFETIME = this._squiggleLifetimeSpinner.getDoubleValue() * 1000.0;
    }

    private void editColor(ColorChip colorChip) {
        this._editColorChip = colorChip;
        Color color = null;
        if (colorChip == this._deBroglieBrightnessPlusChip) {
            color = DeBroglieBrightnessNode.PLUS_COLOR;
        } else if (colorChip == this._deBroglieBrightnessZeroChip) {
            color = DeBroglieBrightnessNode.ZERO_COLOR;
        } else if (colorChip == this._deBroglieBrightnessMinusChip) {
            color = DeBroglieBrightnessNode.MINUS_COLOR;
        } else if (colorChip == this._deBroglieBrightnessMagnitudePlusChip) {
            color = DeBroglieBrightnessMagnitudeNode.PLUS_COLOR;
        } else if (colorChip == this._deBroglieBrightnessMagnitudeZeroChip) {
            color = DeBroglieBrightnessMagnitudeNode.ZERO_COLOR;
        } else {
            throw new UnsupportedOperationException("unsupported ColorChip");
        }
        this.closeColorChooser();
        String string = "Color Chooser";
        PhetFrame phetFrame = PhetApplication.getInstance().getPhetFrame();
        this._colorChooserDialog = ColorChooserFactory.createDialog(string, phetFrame, color, this);
        this._colorChooserDialog.show();
    }

    private void closeColorChooser() {
        if (this._colorChooserDialog != null) {
            this._colorChooserDialog.dispose();
        }
    }

    public void colorChanged(Color color) {
        this.handleColorChange(color);
    }

    public void ok(Color color) {
        this.handleColorChange(color);
    }

    public void cancelled(Color color) {
        this.handleColorChange(color);
    }

    private void handleColorChange(Color color) {
        this.setColor(this._editColorChip, color);
        if (this._editColorChip == this._deBroglieBrightnessPlusChip) {
            DeBroglieBrightnessNode.PLUS_COLOR = color;
        } else if (this._editColorChip == this._deBroglieBrightnessZeroChip) {
            DeBroglieBrightnessNode.ZERO_COLOR = color;
        } else if (this._editColorChip == this._deBroglieBrightnessMinusChip) {
            DeBroglieBrightnessNode.MINUS_COLOR = color;
        } else if (this._editColorChip == this._deBroglieBrightnessMagnitudePlusChip) {
            DeBroglieBrightnessMagnitudeNode.MAX_COLOR = color;
        } else if (this._editColorChip == this._deBroglieBrightnessMagnitudeZeroChip) {
            DeBroglieBrightnessMagnitudeNode.MIN_COLOR = color;
        } else {
            throw new UnsupportedOperationException("unsupported ColorChip");
        }
    }

    private static class ColorChip
    extends JLabel {
    }

    private class EventListener
    extends MouseAdapter
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
            Object object = changeEvent.getSource();
            if (object == DeveloperControlsDialog.this._maxParticlesSpinner.getSpinner()) {
                DeveloperControlsDialog.this.handleMaxParticlesSpinner();
            } else if (object == DeveloperControlsDialog.this._absorptionClosenessSpinner.getSpinner()) {
                DeveloperControlsDialog.this.handleAbsorptionClosenessSpinner();
            } else if (object == DeveloperControlsDialog.this._rutherfordScatteringOutputCheckBox) {
                DeveloperControlsDialog.this.handleRutherfordScatteringOutputCheckBox();
            } else if (object == DeveloperControlsDialog.this._wavelengthHiliteThreshold.getSpinner()) {
                DeveloperControlsDialog.this.handleWavelengthHiliteThresholdSpinner();
            } else if (object == DeveloperControlsDialog.this._absorptionCheckBox) {
                DeveloperControlsDialog.this.handleAbsorptionEmissionCheckBoxes();
            } else if (object == DeveloperControlsDialog.this._spontanuousEmissionCheckBox) {
                DeveloperControlsDialog.this.handleAbsorptionEmissionCheckBoxes();
            } else if (object == DeveloperControlsDialog.this._stimulatedEmissionCheckBox) {
                DeveloperControlsDialog.this.handleAbsorptionEmissionCheckBoxes();
            } else if (object == DeveloperControlsDialog.this._minStateTimeSpinner.getSpinner()) {
                DeveloperControlsDialog.this.handleMinStateTime();
            } else if (object == DeveloperControlsDialog.this._metastableTimeSpinner.getSpinner()) {
                DeveloperControlsDialog.this.handleMetastableTimeSpinner();
            } else if (object == DeveloperControlsDialog.this._squiggleLifetimeSpinner.getSpinner()) {
                DeveloperControlsDialog.this.handleSquiggleLifetimeSpinner();
            } else {
                throw new UnsupportedOperationException("unsupported ChangeEvent source: " + object);
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            Object object = mouseEvent.getSource();
            if (!(object instanceof ColorChip)) {
                throw new UnsupportedOperationException("unsupported MouseEvent source: " + object);
            }
            DeveloperControlsDialog.this.editColor((ColorChip)object);
        }
    }

    private static class TitleLabel
    extends JLabel {
        public TitleLabel(String string) {
            super(string);
            this.setForeground(TITLE_COLOR);
            this.setFont(TITLE_FONT);
        }
    }
}

