/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.hydrogenatom.control;

import edu.colorado.phet.common.piccolophet.nodes.mediabuttons.PiccoloClockControlPanel;
import edu.colorado.phet.hydrogenatom.HAConstants;
import edu.colorado.phet.hydrogenatom.HAResources;
import edu.colorado.phet.hydrogenatom.model.HAClock;
import java.awt.Dimension;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class HAClockControlPanel
extends PiccoloClockControlPanel {
    private HAClock _clock;
    private JSlider _clockIndexSlider;

    public HAClockControlPanel(HAClock hAClock) {
        super(hAClock);
        double d = HAConstants.DEFAULT_CLOCK_STEP;
        this._clock = hAClock;
        this._clock.setDt(d);
        this._clockIndexSlider = new JSlider();
        this._clockIndexSlider.setMinimum(0);
        this._clockIndexSlider.setMaximum(HAConstants.CLOCK_STEPS.length - 1);
        this._clockIndexSlider.setMajorTickSpacing(1);
        this._clockIndexSlider.setPaintTicks(true);
        this._clockIndexSlider.setPaintLabels(true);
        this._clockIndexSlider.setSnapToTicks(true);
        this._clockIndexSlider.setValue(1);
        String string = HAResources.getString("label.clockSpeed.slow");
        String string2 = HAResources.getString("label.clockSpeed.fast");
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        hashtable.put(new Integer(this._clockIndexSlider.getMinimum()), new JLabel(string));
        hashtable.put(new Integer(this._clockIndexSlider.getMaximum()), new JLabel(string2));
        this._clockIndexSlider.setLabelTable(hashtable);
        Dimension dimension = this._clockIndexSlider.getPreferredSize();
        Dimension dimension2 = new Dimension(150, (int)dimension.getHeight());
        this._clockIndexSlider.setPreferredSize(dimension2);
        this.addBetweenTimeDisplayAndButtons(this._clockIndexSlider);
        this._clockIndexSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                HAClockControlPanel.this.handleClockIndexChange();
            }
        });
    }

    private void handleClockIndexChange() {
        int n = this._clockIndexSlider.getValue();
        double d = HAConstants.CLOCK_STEPS[n];
        this._clock.setDt(d);
    }
}

