/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.util;

import edu.colorado.phet.common.phetcommon.view.graphics.RoundGradientPaint;
import edu.colorado.phet.common.phetcommon.view.util.VisibleColor;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.Color;
import java.awt.Image;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.util.HashMap;

public class PhotonImageFactory
extends PhetPNode {
    private static final Color HILITE_COLOR = new Color(255, 255, 255, 180);
    private static final Color CROSSHAIRS_COLOR = new Color(255, 255, 255, 100);
    private static final Color UV_IR_COLOR = new Color(160, 160, 160);
    private static final Color UV_CROSSHAIRS_COLOR = VisibleColor.wavelengthToColor(400.0, UV_IR_COLOR, UV_IR_COLOR);
    private static final Color IR_CROSSHAIRS_COLOR = VisibleColor.wavelengthToColor(715.0, UV_IR_COLOR, UV_IR_COLOR);
    private static final Integer UV_IMAGE_KEY = new Integer(379);
    private static final Integer IR_IMAGE_KEY = new Integer(781);
    private static final ImageCache IMAGE_CACHE = new ImageCache();

    public static final Image lookupPhotonImage(double d, double d2) {
        Image image = IMAGE_CACHE.get(d, d2);
        if (image == null) {
            image = PhotonImageFactory.createPhotonImage(d, d2);
            IMAGE_CACHE.put(d, d2, image);
        }
        return image;
    }

    public static final Image createPhotonImage(double d, double d2) {
        PNode pNode = new PNode();
        Color color = VisibleColor.wavelengthToColor(d, UV_IR_COLOR, UV_IR_COLOR);
        double d3 = d2;
        Ellipse2D.Double double_ = new Ellipse2D.Double(-d3 / 2.0, -d3 / 2.0, d3, d3);
        Color color2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), 0);
        RoundGradientPaint roundGradientPaint = new RoundGradientPaint(0.0, 0.0, color, new Point2D.Double(0.4 * d3, 0.4 * d3), color2);
        PPath pPath = new PPath();
        pPath.setPathTo(double_);
        pPath.setPaint(roundGradientPaint);
        pPath.setStroke(null);
        pNode.addChild(pPath);
        double d4 = 0.5 * d2;
        Ellipse2D.Double double_2 = new Ellipse2D.Double(-d4 / 2.0, -d4 / 2.0, d4, d4);
        Color color3 = new Color(color.getRed(), color.getGreen(), color.getBlue(), 130);
        RoundGradientPaint roundGradientPaint2 = new RoundGradientPaint(0.0, 0.0, HILITE_COLOR, new Point2D.Double(0.25 * d4, 0.25 * d4), color3);
        PPath pPath2 = new PPath();
        pPath2.setPathTo(double_2);
        pPath2.setPaint(roundGradientPaint2);
        pPath2.setStroke(null);
        pNode.addChild(pPath2);
        PNode pNode2 = new PNode();
        PNode pNode3 = PhotonImageFactory.createCrosshair(d, 1.15 * d4);
        PNode pNode4 = PhotonImageFactory.createCrosshair(d, 0.8 * d4);
        pNode4.rotate(Math.toRadians(45.0));
        pNode2.addChild(pNode4);
        pNode2.addChild(pNode3);
        pNode2.rotate(Math.toRadians(18.0));
        pNode.addChild(pNode2);
        return pNode.toImage();
    }

    private static PNode createCrosshair(double d, double d2) {
        Color color = CROSSHAIRS_COLOR;
        if (d < 380.0) {
            color = UV_CROSSHAIRS_COLOR;
        } else if (d > 780.0) {
            color = IR_CROSSHAIRS_COLOR;
        }
        double d3 = d2;
        double d4 = 0.15 * d3;
        Ellipse2D.Double double_ = new Ellipse2D.Double(-d3 / 2.0, -d4 / 2.0, d3, d4);
        PPath pPath = new PPath();
        pPath.setPathTo(double_);
        pPath.setPaint(color);
        pPath.setStroke(null);
        PPath pPath2 = new PPath();
        pPath2.setPathTo(double_);
        pPath2.setPaint(color);
        pPath2.setStroke(null);
        pPath2.rotate(Math.toRadians(90.0));
        PNode pNode = new PNode();
        pNode.addChild(pPath);
        pNode.addChild(pPath2);
        return pNode;
    }

    private static class ImageCache {
        private HashMap _diameterMap = new HashMap();

        public void put(double d, double d2, Image image) {
            Object object = this.diameterToKey(d2);
            HashMap<Object, Image> hashMap = (HashMap<Object, Image>)this._diameterMap.get(object);
            if (hashMap == null) {
                hashMap = new HashMap<Object, Image>();
                this._diameterMap.put(object, hashMap);
            }
            Object object2 = this.wavelengthToKey(d);
            hashMap.put(object2, image);
        }

        public Image get(double d, double d2) {
            Image image = null;
            Object object = this.diameterToKey(d2);
            HashMap hashMap = (HashMap)this._diameterMap.get(object);
            if (hashMap != null) {
                Object object2 = this.wavelengthToKey(d);
                image = (Image)hashMap.get(object2);
            }
            return image;
        }

        private Object diameterToKey(double d) {
            return new Double(d);
        }

        private Object wavelengthToKey(double d) {
            Integer n = null;
            n = d < 380.0 ? UV_IMAGE_KEY : (d > 780.0 ? IR_IMAGE_KEY : new Integer((int)d));
            return n;
        }
    }
}

