/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.event;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class ConstrainedDragHandler
extends PBasicInputEventHandler {
    private Rectangle2D _dragBounds = new Rectangle2D.Double();
    private Point2D _nodeCenter;
    private Point2D _pressedOffset;
    private Point2D _adjustedMousePosition;
    private boolean _horizontalLockEnabled;
    private boolean _verticalLockEnabled;
    private boolean _treatAsPointEnabled;
    private boolean _markAsHandled;
    private boolean _useFullBounds;
    private boolean _isDragging;

    public ConstrainedDragHandler() {
        this(null);
    }

    public ConstrainedDragHandler(Rectangle2D rectangle2D) {
        if (rectangle2D != null) {
            this._dragBounds.setRect(rectangle2D);
        }
        this._nodeCenter = new Point2D.Double();
        this._pressedOffset = new Point2D.Double();
        this._adjustedMousePosition = new Point2D.Double();
        this._verticalLockEnabled = false;
        this._horizontalLockEnabled = false;
        this._treatAsPointEnabled = false;
        this._markAsHandled = false;
        this._useFullBounds = true;
        this._isDragging = false;
    }

    public void setDragBounds(Rectangle2D rectangle2D) {
        this.setDragBounds(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public void setDragBounds(double d, double d2, double d3, double d4) {
        this._dragBounds.setRect(d, d2, d3, d4);
    }

    public void setVerticalLockEnabled(boolean bl) {
        this._verticalLockEnabled = bl;
    }

    public void setTreatAsPointEnabled(boolean bl) {
        this._treatAsPointEnabled = bl;
    }

    public void mousePressed(PInputEvent pInputEvent) {
        this._isDragging = true;
        Point2D point2D = pInputEvent.getPosition();
        PNode pNode = pInputEvent.getPickedNode();
        Rectangle2D rectangle2D = this.getNodeBounds(pNode);
        double d = point2D.getX() - rectangle2D.getX();
        double d2 = point2D.getY() - rectangle2D.getY();
        this._pressedOffset.setLocation(d, d2);
        pInputEvent.setHandled(this._markAsHandled);
    }

    public void mouseReleased(PInputEvent pInputEvent) {
        this._isDragging = false;
    }

    public void mouseDragged(PInputEvent pInputEvent) {
        if (!this._dragBounds.isEmpty()) {
            if (this._treatAsPointEnabled) {
                this.dragConstrainPoint(pInputEvent);
            } else {
                this.dragConstrainBounds(pInputEvent);
            }
        }
        pInputEvent.setHandled(this._markAsHandled);
    }

    private void dragConstrainPoint(PInputEvent pInputEvent) {
        Point2D point2D = pInputEvent.getPosition();
        PNode pNode = pInputEvent.getPickedNode();
        Rectangle2D rectangle2D = this.getNodeBounds(pNode);
        double d = point2D.getX() - this._pressedOffset.getX() + this._nodeCenter.getX();
        double d2 = point2D.getY() - this._pressedOffset.getY() + this._nodeCenter.getY();
        this._adjustedMousePosition.setLocation(d, d2);
        double d3 = 0.0;
        d3 = this._horizontalLockEnabled ? 0.0 : (this._adjustedMousePosition.getX() < this._dragBounds.getX() ? this._dragBounds.getX() - rectangle2D.getX() - this._nodeCenter.getX() : (this._adjustedMousePosition.getX() > this._dragBounds.getX() + this._dragBounds.getWidth() ? this._dragBounds.getX() + this._dragBounds.getWidth() - rectangle2D.getX() - this._nodeCenter.getX() : point2D.getX() - rectangle2D.getX() - this._pressedOffset.getX()));
        double d4 = 0.0;
        d4 = this._verticalLockEnabled ? 0.0 : (this._adjustedMousePosition.getY() < this._dragBounds.getY() ? this._dragBounds.getY() - rectangle2D.getY() - this._nodeCenter.getY() : (this._adjustedMousePosition.getY() > this._dragBounds.getY() + this._dragBounds.getHeight() ? this._dragBounds.getY() + this._dragBounds.getHeight() - rectangle2D.getY() - this._nodeCenter.getY() : point2D.getY() - rectangle2D.getY() - this._pressedOffset.getY()));
        if (d3 != 0.0 || d4 != 0.0) {
            pNode.translate(d3, d4);
        }
    }

    private void dragConstrainBounds(PInputEvent pInputEvent) {
        Point2D point2D = pInputEvent.getPosition();
        PNode pNode = pInputEvent.getPickedNode();
        Rectangle2D rectangle2D = this.getNodeBounds(pNode);
        double d = point2D.getX() - this._pressedOffset.getX();
        double d2 = point2D.getY() - this._pressedOffset.getY();
        this._adjustedMousePosition.setLocation(d, d2);
        double d3 = 0.0;
        d3 = this._horizontalLockEnabled ? 0.0 : (this._adjustedMousePosition.getX() < this._dragBounds.getX() ? this._dragBounds.getX() - rectangle2D.getX() : (this._adjustedMousePosition.getX() + rectangle2D.getWidth() > this._dragBounds.getX() + this._dragBounds.getWidth() ? this._dragBounds.getX() + this._dragBounds.getWidth() - rectangle2D.getWidth() - rectangle2D.getX() : point2D.getX() - rectangle2D.getX() - this._pressedOffset.getX()));
        double d4 = 0.0;
        d4 = this._verticalLockEnabled ? 0.0 : (this._adjustedMousePosition.getY() < this._dragBounds.getY() ? this._dragBounds.getY() - rectangle2D.getY() : (this._adjustedMousePosition.getY() + rectangle2D.getHeight() > this._dragBounds.getY() + this._dragBounds.getHeight() ? this._dragBounds.getY() + this._dragBounds.getHeight() - rectangle2D.getHeight() - rectangle2D.getY() : point2D.getY() - rectangle2D.getY() - this._pressedOffset.getY()));
        if (d3 != 0.0 || d4 != 0.0) {
            pNode.translate(d3, d4);
        }
    }

    private Rectangle2D getNodeBounds(PNode pNode) {
        if (this._useFullBounds) {
            return pNode.getGlobalFullBounds();
        }
        return pNode.getGlobalBounds();
    }
}

