/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.view.menu;

import edu.colorado.phet.common.phetcommon.application.ISimInfo;
import edu.colorado.phet.common.phetcommon.preferences.PhetPreferences;
import edu.colorado.phet.common.phetcommon.preferences.PreferencesDialog;
import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.statistics.SessionMessage;
import edu.colorado.phet.common.phetcommon.view.PhetFrame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class PhetFileMenu
extends JMenu {
    public PhetFileMenu(final PhetFrame phetFrame, ISimInfo iSimInfo) {
        super(PhetCommonResources.getInstance().getLocalizedString("Common.FileMenu.Title"));
        this.setMnemonic(PhetCommonResources.getInstance().getLocalizedString("Common.FileMenu.TitleMnemonic").charAt(0));
        if (iSimInfo.isPreferencesEnabled()) {
            this.addPreferencesMenuItem(phetFrame, iSimInfo);
            this.addSeparator();
        }
        JMenuItem jMenuItem = new JMenuItem(PhetCommonResources.getInstance().getLocalizedString("Common.FileMenu.Exit"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                phetFrame.getApplication().exit();
            }
        });
        jMenuItem.setMnemonic(PhetCommonResources.getInstance().getLocalizedString("Common.FileMenu.ExitMnemonic").charAt(0));
        this.add(jMenuItem);
    }

    private void addPreferencesMenuItem(final PhetFrame phetFrame, final ISimInfo iSimInfo) {
        JMenuItem jMenuItem = new JMenuItem(PhetCommonResources.getInstance().getLocalizedString("Common.FileMenu.Preferences"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                new PreferencesDialog(phetFrame, SessionMessage.getInstance(), PhetPreferences.getInstance(), iSimInfo.isStatisticsFeatureIncluded(), iSimInfo.isUpdatesFeatureIncluded(), iSimInfo.isDev()).setVisible(true);
            }
        });
        jMenuItem.setMnemonic(PhetCommonResources.getInstance().getLocalizedString("Common.FileMenu.PreferencesMnemonic").charAt(0));
        this.add(jMenuItem);
    }
}

