/*
 * Decompiled with CFR 0.152.
 */
package com.thinktankmaths.logging;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

public class CustomFormatter
extends Formatter {
    private static final String DEFAULT_FORMAT = "%L: %m [%c.%M %t]";
    private final MessageFormat messageFormat;
    private final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");

    public CustomFormatter() {
        String string = this.getClass().getName() + ".format";
        String string2 = LogManager.getLogManager().getProperty(string);
        if (string2 == null || string2.trim().length() == 0) {
            string2 = DEFAULT_FORMAT;
        }
        if (string2.contains("{") || string2.contains("}")) {
            throw new IllegalArgumentException("curly braces not allowed");
        }
        string2 = string2.replace("%L", "{0}").replace("%m", "{1}").replace("%M", "{2}").replace("%t", "{3}").replace("%c", "{4}").replace("%T", "{5}").replace("%n", "{6}").replace("%C", "{7}") + "\n";
        this.messageFormat = new MessageFormat(string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String format(LogRecord logRecord) {
        Serializable serializable;
        String[] stringArray = new String[8];
        stringArray[0] = logRecord.getLevel().toString();
        stringArray[1] = logRecord.getMessage();
        if ((stringArray[1] == null || stringArray[1].length() == 0) && (serializable = logRecord.getThrown()) != null) {
            stringArray[1] = serializable.getMessage();
        }
        stringArray[1] = logRecord.getMessage();
        stringArray[2] = logRecord.getSourceMethodName() != null ? logRecord.getSourceMethodName() : "?";
        serializable = new Date(logRecord.getMillis());
        DateFormat dateFormat = this.dateFormat;
        synchronized (dateFormat) {
            stringArray[3] = this.dateFormat.format((Date)serializable);
        }
        stringArray[4] = logRecord.getSourceClassName() != null ? logRecord.getSourceClassName() : "?";
        stringArray[5] = Integer.valueOf(logRecord.getThreadID()).toString();
        stringArray[6] = logRecord.getLoggerName();
        int n = stringArray[4].lastIndexOf(".") + 1;
        stringArray[7] = n > 0 && n < stringArray[4].length() ? stringArray[4].substring(n) : stringArray[4];
        MessageFormat messageFormat = this.messageFormat;
        synchronized (messageFormat) {
            return this.messageFormat.format(stringArray);
        }
    }
}

