/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.view.piccolo.detectorscreen;

import edu.colorado.phet.common.phetcommon.math.Function;
import edu.colorado.phet.quantumwaveinterference.QWIModule;
import edu.colorado.phet.quantumwaveinterference.model.CollapseComputation;
import edu.colorado.phet.quantumwaveinterference.model.QWIModel;
import edu.colorado.phet.quantumwaveinterference.model.Wavefunction;
import edu.colorado.phet.quantumwaveinterference.view.QWIPanel;
import edu.colorado.phet.quantumwaveinterference.view.piccolo.detectorscreen.DetectorSheetPNode;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Random;

public class IntensityManager {
    private QWIModule qwiModule;
    private QWIPanel QWIPanel;
    private DetectorSheetPNode detectorSheetPNode;
    private Random random;
    private int detectorRegionHeight = 2;
    private int detectionRegionY = 2;
    private double probabilityScaleFudgeFactor = 1.0;
    public static double NORM_DECREMENT = 1.0;
    private int multiplier = 1;
    private ArrayList listeners = new ArrayList();
    private double minimumProbabalityForDetection = 0.0;
    private int countsAboveZero = 0;
    private boolean allowProbabilityThreshold = false;
    private boolean allowTimeThreshold = false;
    private int timeThresholdCount = 0;

    public IntensityManager(QWIModule qWIModule, QWIPanel qWIPanel, DetectorSheetPNode detectorSheetPNode) {
        this.detectorSheetPNode = detectorSheetPNode;
        this.qwiModule = qWIModule;
        this.QWIPanel = qWIPanel;
        this.random = new Random();
        qWIModule.getQWIModel().addListener(new QWIModel.Adapter(){

            public void propagatorChanged() {
                IntensityManager.this.countsAboveZero = 0;
            }

            public void sizeChanged() {
                IntensityManager.this.countsAboveZero = 0;
            }

            public void particleFired(QWIModel qWIModel) {
                IntensityManager.this.countsAboveZero = 0;
            }
        });
    }

    public void tryDetecting() {
        Wavefunction wavefunction = this.getDetectionRegion();
        double d = wavefunction.getMagnitude() * this.probabilityScaleFudgeFactor;
        if (d >= 1.0E-4) {
            ++this.countsAboveZero;
        }
        for (int i = 0; i < this.multiplier; ++i) {
            double d2 = this.random.nextDouble();
            if (!this.isAboveTimeThreshold() || !(d2 <= d) || !this.isAboveThreshold(wavefunction)) continue;
            this.detectOne(wavefunction);
            this.updateWavefunctionAfterDetection();
            this.notifyDetection();
            this.countsAboveZero = 0;
        }
    }

    private boolean isAboveTimeThreshold() {
        return this.allowTimeThreshold ? this.countsAboveZero > this.timeThresholdCount : true;
    }

    private boolean isAboveThreshold(Wavefunction wavefunction) {
        return this.allowProbabilityThreshold ? wavefunction.getMagnitude() >= this.minimumProbabalityForDetection : true;
    }

    public void setHighIntensityMode() {
        this.setMultiplier(100);
        this.setProbabilityScaleFudgeFactor(10.0);
        this.setNormDecrement(0.0);
        this.detectorSheetPNode.setHighIntensityMode();
    }

    public void reset() {
    }

    public void setTimeThreshold(boolean bl) {
        this.allowTimeThreshold = bl;
        System.out.println("allowTimeThreshold = " + bl);
    }

    public void setMinimumProbabilityForDetection(double d) {
        this.minimumProbabalityForDetection = d;
        System.out.println("this.minimumProbabalityForDetection = " + this.minimumProbabalityForDetection);
    }

    public void setTimeThreshold(int n) {
        this.timeThresholdCount = n;
        System.out.println("timeThresholdCount = " + n);
    }

    private void notifyDetection() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.detectionOccurred();
        }
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    private void detectOne(Wavefunction wavefunction) {
        Point point = new CollapseComputation().getCollapsePoint(wavefunction, wavefunction.getBounds());
        double d = Math.abs(this.getModelToViewTransform1d().evaluate(point.x) - this.getModelToViewTransform1d().evaluate(point.x + 1));
        double d2 = d / 2.0;
        double d3 = this.random.nextDouble() * d2 * (this.random.nextBoolean() ? 1.0 : -1.0);
        double d4 = this.getModelToViewTransform1d().evaluate(point.x) + d3;
        double d5 = this.getDetectY();
        this.detectorSheetPNode.addDetectionEvent(d4, d5);
    }

    public Function.LinearFunction getModelToViewTransform1d() {
        return new Function.LinearFunction(0.0, this.getDiscreteModel().getGridWidth(), 0.0, this.detectorSheetPNode.getBufferedImage().getWidth());
    }

    private int getDetectY() {
        return (int)(this.random.nextDouble() * (double)this.detectorSheetPNode.getDetectorHeight() * 0.5);
    }

    private void updateWavefunctionAfterDetection() {
        this.getDiscreteModel().updateWavefunctionAfterDetection();
    }

    public Wavefunction getDetectionRegion() {
        return this.getDiscreteModel().getDetectionRegion(0, this.getDetectionRegionY(), this.getDiscreteModel().getWavefunction().getWidth(), this.detectorRegionHeight);
    }

    private int getDetectionRegionY() {
        return this.detectionRegionY;
    }

    public QWIPanel getSchrodingerPanel() {
        return this.QWIPanel;
    }

    private QWIModel getDiscreteModel() {
        return this.qwiModule.getQWIModel();
    }

    public double getProbabilityScaleFudgeFactor() {
        return this.probabilityScaleFudgeFactor;
    }

    public void setProbabilityScaleFudgeFactor(double d) {
        this.probabilityScaleFudgeFactor = d;
    }

    public double getNormDecrement() {
        return NORM_DECREMENT;
    }

    public void setNormDecrement(double d) {
        NORM_DECREMENT = d;
    }

    public int getMultiplier() {
        return this.multiplier;
    }

    public void setMultiplier(int n) {
        this.multiplier = n;
    }

    public static interface Listener {
        public void detectionOccurred();
    }
}

