/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.view.piccolo.detectorscreen;

import edu.colorado.phet.common.phetcommon.math.Function;
import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.quantumwaveinterference.model.QWIModel;
import edu.colorado.phet.quantumwaveinterference.model.Wavefunction;
import edu.colorado.phet.quantumwaveinterference.view.QWIPanel;
import edu.colorado.phet.quantumwaveinterference.view.colormaps.ColorData;
import edu.colorado.phet.quantumwaveinterference.view.piccolo.detectorscreen.DetectorSheetPNode;
import edu.colorado.phet.quantumwaveinterference.view.piccolo.detectorscreen.IntensityManager;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;

public class ContinuousDisplay {
    private QWIPanel QWIPanel;
    private IntensityManager intensityManager;
    private double[] histogram;
    private double brightness = 1.0;
    private ColorData colorData;

    public ContinuousDisplay(QWIPanel qWIPanel, IntensityManager intensityManager) {
        this.QWIPanel = qWIPanel;
        this.intensityManager = intensityManager;
        this.histogram = new double[this.getWavefunction().getWidth()];
    }

    private Wavefunction getWavefunction() {
        return this.getDiscreteModel().getWavefunction();
    }

    private QWIModel getDiscreteModel() {
        return this.getSchrodingerPanel().getDiscreteModel();
    }

    private QWIPanel getSchrodingerPanel() {
        return this.intensityManager.getSchrodingerPanel();
    }

    public void updateValues() {
        Wavefunction wavefunction = this.intensityManager.getDetectionRegion();
        if (this.histogram.length != wavefunction.getWidth()) {
            this.histogram = new double[wavefunction.getWidth()];
        }
        int n = 0;
        while (n < wavefunction.getWidth()) {
            double d = 0.0;
            for (int i = 0; i < wavefunction.getHeight(); ++i) {
                d += wavefunction.valueAt(n, i).abs() * this.intensityManager.getProbabilityScaleFudgeFactor();
            }
            int n2 = n++;
            this.histogram[n2] = this.histogram[n2] + d;
        }
        this.paintSheet();
    }

    private void paintSheet() {
        BufferedImage bufferedImage = this.getDetectorSheetPNode().getBufferedImage();
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, 1000, 1000);
        Function.LinearFunction linearFunction = this.intensityManager.getModelToViewTransform1d();
        if (this.isFadeEnabled()) {
            this.fadeHistogram();
        }
        for (int i = 0; i < this.histogram.length; ++i) {
            Color color = this.toColorBlackBackground(this.histogram[i]);
            int n = (int)(linearFunction.evaluate(i) * this.getWaveImageScaleX());
            int n2 = (int)(linearFunction.evaluate(i + 1) * this.getWaveImageScaleX());
            graphics2D.setColor(color);
            graphics2D.fillRect(n, 0, n2 - n, 100);
        }
        this.getDetectorSheetPNode().histogramChanged();
        graphics2D.dispose();
    }

    private DetectorSheetPNode getDetectorSheetPNode() {
        return this.QWIPanel.getDetectorSheetPNode();
    }

    private boolean isFadeEnabled() {
        return this.getSchrodingerPanel().isFadeEnabled();
    }

    private double getWaveImageScaleX() {
        return 1.0;
    }

    private Color toColorBlackBackground(double d) {
        float f = (float)(d / 10.0);
        f = (float)((double)f * this.brightness);
        f = (float)MathUtil.clamp(0.0, f, 1.0);
        if (this.colorData == null) {
            return new Color(f * 0.8f, f * 0.8f, f);
        }
        return this.colorData.toColor(f);
    }

    private void fadeHistogram() {
        int n = 0;
        while (n < this.histogram.length) {
            int n2 = n++;
            this.histogram[n2] = this.histogram[n2] * 0.9;
        }
    }

    public void setPhotonColor(ColorData colorData) {
        this.colorData = colorData;
    }

    public void setBrightness(double d) {
        Function.LinearFunction linearFunction = new Function.LinearFunction(0.0, 0.1, 0.0, 1.0);
        this.brightness = linearFunction.evaluate(d);
    }
}

