/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.view.gun;

import edu.colorado.phet.quantumwaveinterference.phetcommon.ImageComboBox;
import edu.colorado.phet.quantumwaveinterference.view.gun.GunParticle;
import edu.colorado.phet.quantumwaveinterference.view.gun.IntensityGunNode;
import java.awt.Point;

public abstract class IntensityBeam
extends ImageComboBox.Item {
    private boolean highIntensityModeOn;
    private double intensity = 0.0;
    private double intensityScale = 0.35;
    private GunParticle gunParticle;

    public IntensityBeam(GunParticle gunParticle) {
        super(gunParticle.getLabel(), gunParticle.getImageLocation());
        this.gunParticle = gunParticle;
        this.setIntensity(0.0);
    }

    public void setHighIntensityModeOn(boolean bl) {
        this.highIntensityModeOn = bl;
    }

    public void setIntensity(double d) {
        this.intensity = d;
        this.gunParticle.setIntensityScale(this.intensity * this.intensityScale);
    }

    public double getIntensity() {
        return this.intensity;
    }

    public void deactivate(IntensityGunNode intensityGunNode) {
        this.setHighIntensityModeOn(false);
        this.gunParticle.deactivate(intensityGunNode);
    }

    public void activate(IntensityGunNode intensityGunNode) {
        this.gunParticle.activate(intensityGunNode);
    }

    public GunParticle getGunParticle() {
        return this.gunParticle;
    }

    public abstract void stepBeam();

    public boolean isHighIntensityModeOn() {
        return this.highIntensityModeOn;
    }

    public double getTotalIntensity() {
        return this.intensity * this.intensityScale;
    }

    public void setIntensityScale(double d) {
        this.intensityScale = d;
    }

    public Point getGunLocation() {
        return new Point(-10, 35);
    }
}

