/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.view.gun;

import edu.colorado.phet.common.phetcommon.math.Function;
import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.quantumwaveinterference.QWIResources;
import edu.colorado.phet.quantumwaveinterference.model.ParticleUnits;
import edu.colorado.phet.quantumwaveinterference.model.Propagator;
import edu.colorado.phet.quantumwaveinterference.model.propagators.ModifiedRichardsonPropagator;
import edu.colorado.phet.quantumwaveinterference.view.gun.AbstractGunNode;
import edu.colorado.phet.quantumwaveinterference.view.gun.GunParticle;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;

public class DefaultGunParticle
extends GunParticle {
    private JSlider velocitySlider;
    private VerticalLayoutPanel controlPanel;
    private ParticleUnits particleUnits;

    public DefaultGunParticle(AbstractGunNode abstractGunNode, String string, String string2, ParticleUnits particleUnits) {
        super(abstractGunNode, string, string2);
        this.particleUnits = particleUnits;
        this.createControls();
    }

    private void createControls() {
        this.velocitySlider = new JSlider(0, 0, 1000, 500);
        TitledBorder titledBorder = new TitledBorder(new LineBorder(Color.white, 1, true), QWIResources.getString("gun.velocity"), 0, 0, new PhetFont(1, 12), Color.white){

            public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                super.paintBorder(component, graphics, n, n2, n3, n4);
            }
        };
        this.controlPanel = new VerticalLayoutPanel();
        this.controlPanel.addFullWidth(this.velocitySlider);
        this.controlPanel.setBorder(titledBorder);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.getLowLabel(), "West");
        jPanel.add((Component)this.getHighLabel(), "East");
        this.controlPanel.addFullWidth(jPanel);
    }

    private JLabel getHighLabel() {
        JLabel jLabel = new JLabel(this.particleUnits.getMaxVelocity().toPrettyString());
        jLabel.setForeground(Color.lightGray);
        return jLabel;
    }

    private JLabel getLowLabel() {
        JLabel jLabel = new JLabel(this.particleUnits.getMinVelocity().toPrettyString());
        jLabel.setForeground(Color.lightGray);
        return jLabel;
    }

    public double getSliderFraction() {
        double d = this.velocitySlider.getValue();
        return d / 1000.0;
    }

    public void activate(AbstractGunNode abstractGunNode) {
        this.active = true;
        this.getSchrodingerModule().setUnits(this.particleUnits);
        this.getDiscreteModel().setPropagator(this.createPropagator());
        abstractGunNode.setGunControls(this.controlPanel);
    }

    public void deactivate(AbstractGunNode abstractGunNode) {
        this.active = false;
        abstractGunNode.removeGunControls();
    }

    private Propagator createPropagator() {
        return new ModifiedRichardsonPropagator(this.getDT(), this.getDiscreteModel().getPotential(), this.getHBar(), this.getParticleMass());
    }

    protected double getHBar() {
        return this.particleUnits.getHbar().getValue();
    }

    private double getDT() {
        return this.particleUnits.getDt().getValue();
    }

    public double getStartPy() {
        return -this.getVelocity() * this.getParticleMass() * 45.0 / (double)this.getDiscreteModel().getGridHeight();
    }

    public double getVelocity() {
        return new Function.LinearFunction(0.0, 1000.0, this.getMinVelocity(), this.getMaxVelocity()).evaluate(this.velocitySlider.getValue());
    }

    private double getMaxVelocity() {
        return this.particleUnits.getMaxVelocity().getValue();
    }

    private double getMinVelocity() {
        return this.particleUnits.getMinVelocity().getValue();
    }

    public void detachListener(GunParticle.ChangeHandler changeHandler) {
        this.velocitySlider.removeChangeListener(changeHandler);
    }

    public void hookupListener(GunParticle.ChangeHandler changeHandler) {
        this.velocitySlider.addChangeListener(changeHandler);
    }

    public Point getGunLocation() {
        Point point = super.getGunLocation();
        point.y -= 35;
        return point;
    }

    public Map getModelParameters() {
        Map map = super.getModelParameters();
        map.put("init_mass", "" + this.getParticleMass());
        map.put("init_vel", "" + this.getVelocity());
        map.put("init_momentum", "" + this.getStartPy());
        map.put("start_y", "" + this.getStartY());
        map.put("initial_dx_lattice", "" + this.getStartDxLattice());
        return map;
    }

    private double getParticleMass() {
        return this.particleUnits.getMass().getValue();
    }

    public boolean isFiring() {
        return false;
    }

    public double getMinimumProbabilityForDetection() {
        return 0.0;
    }

    public boolean getTimeThresholdAllowed() {
        return true;
    }

    public int getTimeThresholdCount() {
        return 5;
    }

    public static DefaultGunParticle createElectron(AbstractGunNode abstractGunNode) {
        return new DefaultGunParticle(abstractGunNode, QWIResources.getString("particles.electrons"), "quantum-wave-interference/images/electron-thumb.jpg", new ParticleUnits.ElectronUnits());
    }

    public static DefaultGunParticle createHelium(AbstractGunNode abstractGunNode) {
        return new DefaultGunParticle(abstractGunNode, QWIResources.getString("particles.helium-atoms"), "quantum-wave-interference/images/atom-thumb.jpg", new ParticleUnits.HeliumUnits());
    }

    public static DefaultGunParticle createNeutron(AbstractGunNode abstractGunNode) {
        return new DefaultGunParticle(abstractGunNode, QWIResources.getString("particles.neutrons"), "quantum-wave-interference/images/neutron.png", new ParticleUnits.NeutronUnits());
    }
}

