/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.view.colormaps;

import edu.colorado.phet.quantumwaveinterference.model.SplitModel;
import edu.colorado.phet.quantumwaveinterference.model.Wavefunction;
import edu.colorado.phet.quantumwaveinterference.modules.intensity.IntensityBeamPanel;
import edu.colorado.phet.quantumwaveinterference.view.colorgrid.ColorMap;
import edu.colorado.phet.quantumwaveinterference.view.colormaps.ColorData;
import edu.colorado.phet.quantumwaveinterference.view.colormaps.WaveValueAccessor;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Rectangle;

public class SplitColorMap
implements ColorMap {
    private SplitModel splitModel;
    private ColorData rootColor;
    private double intensityScale = 20.0;
    private WaveValueAccessor waveValueAccessor = new WaveValueAccessor.Magnitude();

    public SplitColorMap(SplitModel splitModel, IntensityBeamPanel intensityBeamPanel) {
        this.splitModel = splitModel;
        this.setRootColor(intensityBeamPanel.getRootColor());
    }

    public Paint getColor(int n, int n2) {
        Rectangle[] rectangleArray = this.splitModel.getDoubleSlitPotential().getSlitAreas();
        double d = 0.0;
        if (this.contains(rectangleArray, n, n2)) {
            d += this.getValue(this.splitModel.getLeftWavefunction(), n, n2);
            d += this.getValue(this.splitModel.getRightWavefunction(), n, n2);
        } else {
            d += this.getValue(this.splitModel.getLeftWavefunction(), n, n2);
            d += this.getValue(this.splitModel.getRightWavefunction(), n, n2);
            d += this.getValue(this.splitModel.getWavefunction(), n, n2);
        }
        if (d > 1.0) {
            d = 1.0;
        }
        if (this.rootColor != null) {
            return this.rootColor.toColor(d);
        }
        return new Color((float)d, (float)d, (float)d);
    }

    private boolean contains(Rectangle[] rectangleArray, int n, int n2) {
        for (int i = 0; i < rectangleArray.length; ++i) {
            Rectangle rectangle = rectangleArray[i];
            if (!rectangle.contains(n, n2)) continue;
            return true;
        }
        return false;
    }

    public void setWaveValueAccessor(WaveValueAccessor waveValueAccessor) {
        this.waveValueAccessor = waveValueAccessor;
    }

    private double getValue(Wavefunction wavefunction, int n, int n2) {
        if (wavefunction.containsLocation(n, n2)) {
            return this.waveValueAccessor.getValue(wavefunction, n, n2) * this.intensityScale;
        }
        return 0.0;
    }

    public void setRootColor(ColorData colorData) {
        this.rootColor = colorData;
    }
}

