/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.view.colormaps;

import edu.colorado.phet.quantumwaveinterference.model.Wavefunction;
import edu.colorado.phet.quantumwaveinterference.view.QWIPanel;
import edu.colorado.phet.quantumwaveinterference.view.colorgrid.ColorMap;
import edu.colorado.phet.quantumwaveinterference.view.colormaps.ColorData;
import edu.colorado.phet.quantumwaveinterference.view.colormaps.WaveValueAccessor;
import java.awt.Paint;

public class PhotonColorMap
implements ColorMap {
    private QWIPanel QWIPanel;
    private WaveValueAccessor waveValueAccessor;
    private double intensityScale = 20.0;
    private ColorData rootColor;

    public PhotonColorMap(QWIPanel qWIPanel, double d, WaveValueAccessor waveValueAccessor) {
        if (waveValueAccessor == null) {
            throw new RuntimeException("Null waveValueAccessor");
        }
        this.QWIPanel = qWIPanel;
        this.waveValueAccessor = waveValueAccessor;
        this.rootColor = new ColorData(d);
    }

    public String toString() {
        return super.toString() + ", waveValueAccessor=" + this.waveValueAccessor + ", rootColor=" + this.rootColor;
    }

    public Paint getColor(int n, int n2) {
        Wavefunction wavefunction = this.QWIPanel.getDiscreteModel().getWavefunction();
        double d = this.waveValueAccessor.getValue(wavefunction, n, n2) * this.intensityScale;
        if (d > 1.0) {
            d = 1.0;
        }
        return this.rootColor.toColor(d);
    }
}

