/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.phetcommon;

import edu.colorado.phet.common.phetcommon.view.PhetLookAndFeel;
import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.quantumwaveinterference.phetcommon.JFontChooser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import javax.swing.BorderFactory;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class UIController
extends VerticalLayoutPanel {
    private PhetLookAndFeel phetLookAndFeel = new PhetLookAndFeel();

    public UIController() {
        JFontChooser jFontChooser = new JFontChooser(null);
        jFontChooser.addListener(new JFontChooser.Listener(){

            public void fontChanged(Font font) {
                UIController.this.phetLookAndFeel.setFont(font);
                UIController.this.apply();
            }
        });
        this.addFullWidth(jFontChooser.getContentPane());
        JFontChooser jFontChooser2 = new JFontChooser(null);
        jFontChooser2.addListener(new JFontChooser.Listener(){

            public void fontChanged(Font font) {
                UIController.this.phetLookAndFeel.setTabFont(font);
                UIController.this.apply();
            }
        });
        this.addFullWidth(jFontChooser2.getContentPane());
        final JColorChooser jColorChooser = new JColorChooser();
        jColorChooser.getSelectionModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                Color color = jColorChooser.getSelectionModel().getSelectedColor();
                UIController.this.phetLookAndFeel.setBackgroundColor(color);
                UIController.this.apply();
            }
        });
        jColorChooser.setBorder(BorderFactory.createTitledBorder("background"));
        this.addFullWidth(jColorChooser);
        final JColorChooser jColorChooser2 = new JColorChooser();
        jColorChooser2.getSelectionModel().addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                Color color = jColorChooser2.getSelectionModel().getSelectedColor();
                UIController.this.phetLookAndFeel.setForegroundColor(color);
                UIController.this.apply();
            }
        });
        jColorChooser2.setBorder(BorderFactory.createTitledBorder("foreground"));
        this.addFullWidth(jColorChooser2);
    }

    private void apply() {
        this.phetLookAndFeel.apply();
        this.synchronizeUI();
    }

    private void synchronizeUI() {
        Frame[] frameArray = JFrame.getFrames();
        for (int i = 0; i < frameArray.length; ++i) {
            Frame frame = frameArray[i];
            UIController.updateComponentTreeUI(frame);
        }
    }

    public static void updateComponentTreeUI(Component component) {
        UIController.updateComponentTreeUI0(component);
        component.invalidate();
        component.validate();
        component.repaint();
    }

    private static void updateComponentTreeUI0(Component component) {
        if (component instanceof UIController) {
            return;
        }
        if (component instanceof JComponent) {
            ((JComponent)component).updateUI();
        }
        Component[] componentArray = null;
        if (component instanceof JMenu) {
            componentArray = ((JMenu)component).getMenuComponents();
        } else if (component instanceof Container) {
            componentArray = ((Container)component).getComponents();
        }
        if (componentArray != null) {
            for (int i = 0; i < componentArray.length; ++i) {
                UIController.updateComponentTreeUI0(componentArray[i]);
            }
        }
    }

    public static void showUIController() {
        JFrame jFrame = new JFrame();
        jFrame.setContentPane(new JScrollPane(new UIController()));
        jFrame.pack();
        jFrame.setSize(jFrame.getSize().width, 700);
        jFrame.setVisible(true);
    }
}

