/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.phetcommon;

import edu.colorado.phet.common.phetcommon.view.util.DoubleGeneralPath;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.BasicStroke;
import java.awt.Color;

public class RulerGraphic
extends PhetPNode {
    private PPath base;
    private String[] readings;
    private String units;
    private int horizontalInset;
    private int numMinorTicksBetweenMajors = 5;
    private double majorTickHeight = 10.0;
    private double minorTickHeight = 6.0;

    public RulerGraphic(String[] stringArray, String string, int n, int n2) {
        this.units = string;
        Color color = new Color(236, 225, 113);
        this.base = new PPath();
        this.base.setPaint(color);
        this.base.setStrokePaint(Color.black);
        this.base.setStroke(new BasicStroke());
        this.readings = stringArray;
        this.horizontalInset = 14;
        this.setBounds(0.0, 0.0, n, n2);
        this.update();
    }

    public void setReadings(String[] stringArray) {
        this.readings = stringArray;
        this.update();
    }

    protected void update() {
        this.doUpdate(this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    protected void internalUpdateBounds(double d, double d2, double d3, double d4) {
        super.internalUpdateBounds(d, d2, d3, d4);
        this.doUpdate(d, d2, d3, d4);
    }

    private void doUpdate(double d, double d2, double d3, double d4) {
        this.removeAllChildren();
        this.base.setPathToRectangle((float)d, (float)d2, (float)d3, (float)d4);
        this.addChild(this.base);
        double d5 = d3 - (double)(this.horizontalInset * 2);
        double d6 = d5 / (double)(this.readings.length - 1);
        double d7 = d6 / (double)this.numMinorTicksBetweenMajors;
        for (int i = 0; i < this.readings.length; ++i) {
            String string = this.readings[i];
            PText pText = new PText(string);
            double d8 = d6 * (double)i + (double)this.horizontalInset;
            double d9 = d4 / 2.0 - pText.getFullBounds().getHeight() / 2.0;
            pText.setOffset(d8 - pText.getFullBounds().getWidth() / 2.0, d9);
            this.addChild(pText);
            DoubleGeneralPath doubleGeneralPath = this.createTickPair(d8, d4, this.majorTickHeight);
            PPath pPath = new PPath(doubleGeneralPath.getGeneralPath(), new BasicStroke());
            pPath.setStrokePaint(Color.black);
            this.addChild(pPath);
            if (i < this.readings.length - 1) {
                for (int j = 1; j < this.numMinorTicksBetweenMajors; ++j) {
                    DoubleGeneralPath doubleGeneralPath2 = this.createTickPair(d8 + (double)j * d7, d4, this.minorTickHeight);
                    PPath pPath2 = new PPath(doubleGeneralPath2.getGeneralPath(), new BasicStroke());
                    pPath2.setStrokePaint(Color.black);
                    this.addChild(pPath2);
                }
            }
            if (i != 0) continue;
            PText pText2 = new PText(this.units);
            pText2.setFont(new PhetFont(22, true));
            this.addChild(pText2);
            pText2.setOffset(pText.getOffset().getX() + pText.getFullBounds().getWidth() + 5.0, pText.getOffset().getY() - pText.getFullBounds().getHeight() / 2.0);
        }
    }

    private DoubleGeneralPath createTickPair(double d, double d2, double d3) {
        DoubleGeneralPath doubleGeneralPath = new DoubleGeneralPath(d, 0.0);
        doubleGeneralPath.lineTo(d, d3);
        doubleGeneralPath.moveTo(d, d2 - d3);
        doubleGeneralPath.lineTo(d, d2);
        return doubleGeneralPath;
    }

    public void setUnitsText(String string) {
        this.units = string;
        this.update();
    }

    public void setMeasurementPixelWidth(double d) {
        this.setWidth(d + (double)(this.horizontalInset * 2));
        this.update();
    }
}

