/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.phetcommon;

import edu.colorado.phet.common.piccolophet.event.BoundedDragHandler;
import edu.umd.cs.piccolo.PCanvas;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class HalfOnscreenDragHandler
extends BoundedDragHandler {
    private PPath dragBounds;
    private PCanvas component;

    public HalfOnscreenDragHandler(PCanvas pCanvas, PNode pNode) {
        super(pNode, new PPath());
        this.component = pCanvas;
        this.dragBounds = (PPath)super.getBoundingNode();
        pCanvas.getLayer().addChild(this.dragBounds);
        this.dragBounds.setPickable(false);
        this.dragBounds.setVisible(false);
        pCanvas.getLayer().addChild(this.dragBounds);
        pCanvas.addComponentListener(new ComponentListener(){

            public void componentHidden(ComponentEvent componentEvent) {
            }

            public void componentMoved(ComponentEvent componentEvent) {
            }

            public void componentResized(ComponentEvent componentEvent) {
                HalfOnscreenDragHandler.this.updateDragBounds();
            }

            public void componentShown(ComponentEvent componentEvent) {
                HalfOnscreenDragHandler.this.updateDragBounds();
            }
        });
        pNode.addPropertyChangeListener("fullBounds", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                HalfOnscreenDragHandler.this.updateDragBounds();
            }
        });
        pNode.addPropertyChangeListener("bounds", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                HalfOnscreenDragHandler.this.updateDragBounds();
            }
        });
    }

    private void updateDragBounds() {
        PNode pNode = super.getDragNode();
        this.dragBounds.setPathTo(new Rectangle2D.Double(-pNode.getFullBounds().getWidth() / 2.0, -pNode.getFullBounds().getHeight() / 2.0, (double)this.component.getWidth() + pNode.getFullBounds().getWidth(), (double)this.component.getHeight() + pNode.getFullBounds().getHeight()));
    }
}

