/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.modules.mandel;

import edu.colorado.phet.quantumwaveinterference.QWIModule;
import edu.colorado.phet.quantumwaveinterference.model.CylinderSource;
import edu.colorado.phet.quantumwaveinterference.model.PhotonWave;
import edu.colorado.phet.quantumwaveinterference.model.QWIModel;
import edu.colorado.phet.quantumwaveinterference.model.Wave;
import edu.colorado.phet.quantumwaveinterference.modules.mandel.MandelModule;
import edu.colorado.phet.quantumwaveinterference.modules.mandel.MandelWave;
import edu.colorado.phet.quantumwaveinterference.modules.mandel.PhotonMandelBeam;

public class DoublePhotonWave
extends PhotonWave {
    private double dPhase = 0.0;
    private MandelModule.BeamParam leftParam;
    private MandelModule.BeamParam rightParam;
    private CylinderSource leftWaveSource;
    private CylinderSource rightWaveSource;
    private PhotonMandelBeam photonMandelBeam;
    double scale = 2.7E-4;

    public DoublePhotonWave(QWIModule qWIModule, QWIModel qWIModel, PhotonMandelBeam photonMandelBeam) {
        super(qWIModule, qWIModel);
        this.photonMandelBeam = photonMandelBeam;
        this.setOn();
        this.setIntensity(1.0);
        this.leftWaveSource = new CylinderSource(this.createRectRegionForCylinder(), this.createWave(super.getPhase()));
        this.rightWaveSource = new CylinderSource(this.createRectRegionForCylinder(), this.createWave(super.getPhase()));
    }

    protected void initializeEntrantWave() {
        this.leftWaveSource.setRegion(this.createRectRegionForCylinder());
        this.rightWaveSource.setRegion(this.createRectRegionForCylinder());
        if (this.leftParam == null) {
            this.leftParam = new MandelModule.BeamParam(this.getMomentum(), 0.0, this.getDiscreteModel().getWaveModel());
            this.rightParam = new MandelModule.BeamParam(this.getMomentum(), 0.0, this.getDiscreteModel().getWaveModel());
        }
        this.updateWaves();
        this.leftWaveSource.initializeEntrantWave(this.leftParam.getWaveModel(), this.getDiscreteModel().getSimulationTime());
        this.rightWaveSource.initializeEntrantWave(this.rightParam.getWaveModel(), this.getDiscreteModel().getSimulationTime());
    }

    private void updateWaves() {
        this.leftWaveSource.setWave(this.createLeftWave());
        this.rightWaveSource.setWave(this.createRightWave());
    }

    public boolean isCombinedWaveModel() {
        return this.leftParam.getWaveModel() == this.rightParam.getWaveModel();
    }

    protected Wave createLeftWave() {
        double d = this.isCombinedWaveModel() ? this.getTotalWaveMagnitudeRight() : 0.0;
        return new MandelWave((int)this.getInsetX(), this.leftParam.getMomentum() * this.scale, this.rightParam.getMomentum() * this.scale, this.getPhase(), this.dPhase, this.getTotalWaveMagnitudeLeft(), d, this.getDiscreteModel().getWavefunction().getWidth());
    }

    protected Wave createRightWave() {
        double d = this.isCombinedWaveModel() ? this.getTotalWaveMagnitudeLeft() : 0.0;
        return new MandelWave((int)this.getInsetX(), this.leftParam.getMomentum() * this.scale, this.rightParam.getMomentum() * this.scale, this.getPhase(), this.dPhase, d, this.getTotalWaveMagnitudeRight(), this.getDiscreteModel().getWavefunction().getWidth());
    }

    private double getInsetX() {
        return (double)this.getDiscreteModel().getWavefunction().getWidth() * DoublePhotonWave.getFractionalInset();
    }

    private double getTotalWaveMagnitudeRight() {
        return this.getMagnitude() * this.getIntensityScale() * this.rightParam.getIntensity();
    }

    private double getTotalWaveMagnitudeLeft() {
        return this.getMagnitude() * this.getIntensityScale() * this.leftParam.getIntensity();
    }

    public static double getFractionalInset() {
        return 0.3;
    }

    public void setBeamParameters(MandelModule.BeamParam beamParam, MandelModule.BeamParam beamParam2) {
        this.setOn();
        this.setIntensity(1.0);
        this.leftParam = beamParam;
        this.rightParam = beamParam2;
        this.updateWaves();
    }

    public void setLeftMomentum(double d) {
        this.leftParam.setMomentum(d);
        this.updateWaves();
    }

    public void setRightMomentum(double d) {
        this.rightParam.setMomentum(d);
        this.updateWaves();
    }
}

