/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.modules.intensity;

import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.quantumwaveinterference.QWIModule;
import edu.colorado.phet.quantumwaveinterference.QWIResources;
import edu.colorado.phet.quantumwaveinterference.QuantumWaveInterferenceApplication;
import edu.colorado.phet.quantumwaveinterference.model.Detector;
import edu.colorado.phet.quantumwaveinterference.model.QWIModel;
import edu.colorado.phet.quantumwaveinterference.model.SplitModel;
import edu.colorado.phet.quantumwaveinterference.modules.intensity.IntensityBeamPanel;
import edu.colorado.phet.quantumwaveinterference.modules.intensity.IntensityControlPanel;
import edu.colorado.phet.quantumwaveinterference.view.QWIPanel;
import edu.colorado.phet.quantumwaveinterference.view.piccolo.RestrictedDetectorGraphic;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;

public class IntensityModule
extends QWIModule {
    private SplitModel splitModel;
    private IntensityBeamPanel intensityBeamPanel;
    private IntensityControlPanel intensityControlPanel;
    private ArrayList listeners = new ArrayList();
    private boolean rightDetectorShouldBeEnabled = false;
    private boolean leftDetectorShouldBeEnabled = false;

    public IntensityModule(QuantumWaveInterferenceApplication quantumWaveInterferenceApplication, IClock iClock) {
        this(QWIResources.getString("module.high-intensity"), quantumWaveInterferenceApplication, iClock);
    }

    protected IntensityModule(String string, PhetApplication phetApplication, IClock iClock) {
        super(string, phetApplication, iClock);
        this.splitModel = new SplitModel();
        this.setQWIModel(this.splitModel);
        this.intensityBeamPanel = this.createIntensityPanel();
        this.setSchrodingerPanel(this.intensityBeamPanel);
        this.intensityControlPanel = new IntensityControlPanel(this);
        this.setSchrodingerControlPanel(this.intensityControlPanel);
        this.synchronizeModel();
        this.getQWIModel().addListener(new QWIModel.Adapter(){

            public void doubleSlitVisibilityChanged() {
                if (!IntensityModule.this.getQWIModel().isDoubleSlitEnabled()) {
                    IntensityModule.this.setRightDetectorEnabled(false);
                    IntensityModule.this.setLeftDetectorEnabled(false);
                }
            }
        });
        this.finishInit();
        this.getSchrodingerPanel().addListener(new QWIPanel.Adapter(){

            public void inverseSlitsChanged() {
                IntensityModule.this.updateDetectors();
            }
        });
        this.getSchrodingerPanel().addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                IntensityModule.this.splitModel.synchronizeDetectorRegions();
            }
        });
        this.getSchrodingerPanel().getDetectorSheetPNode().setFadeDelay(10);
    }

    private boolean isInverseSlits() {
        return this.getSchrodingerPanel().isInverseSlits();
    }

    protected IntensityBeamPanel createIntensityPanel() {
        return new IntensityBeamPanel(this);
    }

    public SplitModel getSplitModel() {
        return this.splitModel;
    }

    public IntensityBeamPanel getIntensityPanel() {
        return this.intensityBeamPanel;
    }

    public boolean isRightDetectorEnabled() {
        return this.splitModel.containsDetector(this.splitModel.getRightDetector());
    }

    public boolean isLeftDetectorEnabled() {
        return this.splitModel.containsDetector(this.splitModel.getLeftDetector());
    }

    private void updateDetectors() {
        this.updateLeftDetector();
        this.updateRightDetector();
    }

    public void setRightDetectorEnabled(boolean bl) {
        this.rightDetectorShouldBeEnabled = bl;
        this.updateRightDetector();
    }

    private void updateRightDetector() {
        this.setRightDetectorActive(this.rightDetectorShouldBeEnabled && !this.isInverseSlits());
    }

    private void setRightDetectorActive(boolean bl) {
        if (!this.getQWIModel().isDoubleSlitEnabled() && bl) {
            return;
        }
        if (this.isRightDetectorEnabled() != bl) {
            this.setDetectorEnabled(this.splitModel.getRightDetector(), bl);
            this.notifyDetectorsChanged();
        }
    }

    public void setLeftDetectorEnabled(boolean bl) {
        this.leftDetectorShouldBeEnabled = bl;
        this.updateLeftDetector();
    }

    private void updateLeftDetector() {
        this.setLeftDetectorActive(this.leftDetectorShouldBeEnabled && !this.isInverseSlits());
    }

    private void setLeftDetectorActive(boolean bl) {
        if (!this.getQWIModel().isDoubleSlitEnabled() && bl) {
            return;
        }
        if (this.isLeftDetectorEnabled() != bl) {
            this.setDetectorEnabled(this.splitModel.getLeftDetector(), bl);
            this.notifyDetectorsChanged();
        }
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    private void notifyDetectorsChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.detectorsChanged();
        }
    }

    private void setDetectorEnabled(Detector detector, boolean bl) {
        boolean bl2 = this.shouldBeSplitMode();
        if (bl) {
            this.splitModel.addDetector(detector);
            RestrictedDetectorGraphic restrictedDetectorGraphic = new RestrictedDetectorGraphic(this.intensityBeamPanel, detector);
            this.intensityBeamPanel.addDetectorGraphic(restrictedDetectorGraphic);
        } else {
            this.splitModel.removeDetector(detector);
            this.intensityBeamPanel.removeDetectorGraphic(detector);
        }
        boolean bl3 = this.shouldBeSplitMode();
        if (bl3 != bl2) {
            this.synchronizeModel();
        }
    }

    private boolean shouldBeSplitMode() {
        return this.isLeftDetectorEnabled() || this.isRightDetectorEnabled();
    }

    private void synchronizeModel() {
        boolean bl = this.shouldBeSplitMode();
        this.splitModel.setSplitMode(bl);
        this.intensityBeamPanel.setSplitMode(bl);
    }

    public static class Adapter
    implements Listener {
        public void detectorsChanged() {
        }
    }

    public static interface Listener {
        public void detectorsChanged();
    }
}

