/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.model.waves;

import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.quantumwaveinterference.model.Wave;
import edu.colorado.phet.quantumwaveinterference.model.WaveSetup;
import edu.colorado.phet.quantumwaveinterference.model.Wavefunction;
import edu.colorado.phet.quantumwaveinterference.model.math.Complex;
import edu.colorado.phet.quantumwaveinterference.model.waves.GaussianWave1D;
import java.awt.geom.Point2D;

public class GaussianWave2D
extends WaveSetup
implements Wave {
    private GaussianWave1D xWave;
    private GaussianWave1D yWave;
    private double globalPhase;
    private double scale = 1.0;

    public GaussianWave2D(Point2D point2D, Vector2D vector2D, double d, double d2) {
        this(point2D, vector2D, d, d, d2);
    }

    public GaussianWave2D(Point2D point2D, Vector2D vector2D, double d, double d2, double d3) {
        this.xWave = new GaussianWave1D(vector2D.getX(), point2D.getX(), d, d3);
        this.yWave = new GaussianWave1D(vector2D.getY(), point2D.getY(), d2, d3);
        super.setWave(this);
    }

    public void initialize(Wavefunction wavefunction, double d) {
        super.initialize(wavefunction, d);
        wavefunction.normalize();
        wavefunction.scale(this.scale);
    }

    public Complex getValue(int n, int n2, double d) {
        Complex complex = this.xWave.getValue(n);
        Complex complex2 = this.yWave.getValue(n2);
        Complex complex3 = complex.times(complex2);
        complex3 = complex3.times(Complex.exponentiateImaginary(this.globalPhase));
        return complex3;
    }

    public void setPhase(double d) {
        this.globalPhase = d;
    }

    public void setScale(double d) {
        this.scale = d;
    }
}

