/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.model.propagators;

import edu.colorado.phet.quantumwaveinterference.model.Potential;
import edu.colorado.phet.quantumwaveinterference.model.Propagator;
import edu.colorado.phet.quantumwaveinterference.model.Wavefunction;
import edu.colorado.phet.quantumwaveinterference.model.math.Complex;
import java.awt.Rectangle;

public class ClassicalWavePropagator
extends Propagator {
    private Wavefunction last2;
    private Wavefunction last;
    private Complex ZERO = new Complex();

    public ClassicalWavePropagator(Potential potential) {
        super(potential);
    }

    public void addInitialization(Wavefunction wavefunction, Wavefunction wavefunction2) {
        if (this.last2 == null) {
            this.last2 = wavefunction2.createEmptyWavefunction();
        }
        if (this.last == null) {
            this.last = wavefunction.createEmptyWavefunction();
        }
        this.last2.add(wavefunction2);
        this.last.add(wavefunction);
    }

    public void propagate(Wavefunction wavefunction) {
        Complex complex = new Complex();
        if (this.last == null) {
            this.last = wavefunction.copy();
            this.last2 = wavefunction.copy();
            return;
        }
        double d = 0.5;
        double d2 = d * d;
        for (int i = 1; i < wavefunction.getWidth() - 1; ++i) {
            for (int j = 1; j < wavefunction.getHeight() - 1; ++j) {
                if (this.getPotential().getPotential(i, j, 0) != 0.0) {
                    wavefunction.setValue(i, j, 0.0, 0.0);
                    continue;
                }
                complex.setValue(0.0, 0.0);
                complex.add(this.last(i + 1, j));
                complex.add(this.last(i - 1, j));
                complex.add(this.last(i, j + 1));
                complex.add(this.last(i, j - 1));
                Complex complex2 = this.last(i, j);
                complex.add(complex2.getReal() * -4.0, complex2.getImaginary() * -4.0);
                complex.scale(d2);
                wavefunction.setValue(i, j, this.last.valueAt(i, j).getReal() * 2.0 - this.last2.valueAt(i, j).getReal() + complex.getReal(), this.last.valueAt(i, j).getImaginary() * 2.0 - this.last2.valueAt(i, j).getImaginary() + complex.getImaginary());
            }
        }
        this.dampHorizontal(wavefunction, 0, 1);
        this.dampHorizontal(wavefunction, wavefunction.getHeight() - 1, -1);
        this.dampVertical(wavefunction, 0, 1);
        this.dampVertical(wavefunction, wavefunction.getWidth() - 1, -1);
        this.last.copyTo(this.last2);
        wavefunction.copyTo(this.last);
        wavefunction.setMagnitudeDirty();
        this.last.setMagnitudeDirty();
        this.last2.setMagnitudeDirty();
    }

    private void dampHorizontal(Wavefunction wavefunction, int n, int n2) {
        for (int i = 0; i < wavefunction.getWidth(); ++i) {
            wavefunction.setValue(i, n, this.last2.valueAt(i, n + n2));
        }
    }

    private void dampVertical(Wavefunction wavefunction, int n, int n2) {
        for (int i = 0; i < wavefunction.getHeight(); ++i) {
            wavefunction.setValue(n, i, this.last2.valueAt(n + n2, i));
        }
    }

    private Complex last(int n, int n2) {
        if (this.getPotential().getPotential(n, n2, 0) == 0.0) {
            return this.last.valueAt(n, n2);
        }
        return this.ZERO;
    }

    public void setDeltaTime(double d) {
    }

    public double getSimulationTime() {
        return 0.0;
    }

    public void reset() {
        this.last2 = null;
        this.last = null;
    }

    public Propagator copy() {
        return new ClassicalWavePropagator(this.getPotential());
    }

    public void setWavefunctionNorm(double d) {
        if (this.last2 != null) {
            this.last2.setMagnitude(d);
        }
        if (this.last != null) {
            this.last.setMagnitude(d);
        }
    }

    public void scale(double d) {
        if (this.last2 != null) {
            this.last2.scale(d);
        }
        if (this.last != null) {
            this.last.scale(d);
        }
    }

    public Wavefunction getLast() {
        return this.last;
    }

    public Wavefunction getLast2() {
        return this.last2;
    }

    public void copyTo(int n, int n2, Propagator propagator) {
        super.copyTo(n, n2, propagator);
        if (propagator instanceof ClassicalWavePropagator) {
            Complex complex;
            ClassicalWavePropagator classicalWavePropagator = (ClassicalWavePropagator)propagator;
            if (this.last2 != null && classicalWavePropagator.last2 != null) {
                complex = this.last2.valueAt(n, n2);
                classicalWavePropagator.last2.setValue(n, n2, complex);
            }
            if (this.last != null && classicalWavePropagator.last != null) {
                complex = this.last.valueAt(n, n2);
                classicalWavePropagator.last.setValue(n, n2, complex);
            }
        } else {
            throw new RuntimeException("Tried to copy Classical to wrong propagator type: " + propagator.getClass().getName());
        }
    }

    public void clearWave(Rectangle rectangle) {
        super.clearWave(rectangle);
        if (this.last2 != null) {
            this.last2.clearRect(rectangle);
        }
        if (this.last != null) {
            this.last.clearRect(rectangle);
        }
    }

    public void splitWave(Rectangle rectangle, Propagator propagator, Propagator propagator2) {
        super.splitWave(rectangle, propagator, propagator2);
        if (propagator instanceof ClassicalWavePropagator && propagator2 instanceof ClassicalWavePropagator) {
            ClassicalWavePropagator classicalWavePropagator = (ClassicalWavePropagator)propagator;
            ClassicalWavePropagator classicalWavePropagator2 = (ClassicalWavePropagator)propagator2;
            if (this.last2 != null && classicalWavePropagator.last2 != null && classicalWavePropagator2.last2 != null) {
                this.last2.splitWave(rectangle, classicalWavePropagator.last2, classicalWavePropagator2.last2);
            }
            if (this.last != null && classicalWavePropagator.last != null && classicalWavePropagator2.last != null) {
                this.last.splitWave(rectangle, classicalWavePropagator.last, classicalWavePropagator2.last);
            }
        } else {
            throw new RuntimeException("Tried to split Classical to wrong propagator type: a=" + propagator.getClass().getName() + ", b=" + propagator2.getClass().getName());
        }
    }

    public void combineWaves(Rectangle rectangle, Propagator propagator, Propagator propagator2) {
        super.combineWaves(rectangle, propagator, propagator2);
        if (propagator instanceof ClassicalWavePropagator && propagator2 instanceof ClassicalWavePropagator) {
            ClassicalWavePropagator classicalWavePropagator = (ClassicalWavePropagator)propagator;
            ClassicalWavePropagator classicalWavePropagator2 = (ClassicalWavePropagator)propagator2;
            if (this.last2 != null && classicalWavePropagator.last2 != null && classicalWavePropagator2.last2 != null) {
                this.last2.combineWaves(rectangle, classicalWavePropagator.last2, classicalWavePropagator2.last2);
            }
            if (this.last != null && classicalWavePropagator.last != null && classicalWavePropagator2.last != null) {
                this.last.combineWaves(rectangle, classicalWavePropagator.last, classicalWavePropagator2.last);
            }
        } else {
            throw new RuntimeException("Tried to combine Classical to wrong propagator type: a=" + propagator.getClass().getName() + ", b=" + propagator2.getClass().getName());
        }
    }

    public void setValue(int n, int n2, double d, double d2) {
        if (this.last != null) {
            this.last.setValue(n, n2, d, d2);
        }
        if (this.last2 != null) {
            this.last2.setValue(n, n2, d, d2);
        }
    }
}

