/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.model.propagators;

import edu.colorado.phet.quantumwaveinterference.model.Potential;
import edu.colorado.phet.quantumwaveinterference.model.Propagator;
import edu.colorado.phet.quantumwaveinterference.model.Wavefunction;
import edu.colorado.phet.quantumwaveinterference.model.math.Complex;

public class AveragePropagator
extends Propagator {
    public AveragePropagator(Potential potential) {
        super(potential);
    }

    public void propagate(Wavefunction wavefunction) {
        Wavefunction wavefunction2 = wavefunction.copy();
        for (int i = 1; i < wavefunction.getWidth() - 1; ++i) {
            for (int j = 1; j < wavefunction.getHeight() - 1; ++j) {
                Complex complex = wavefunction2.valueAt(i + 1, j).plus(wavefunction2.valueAt(i - 1, j)).plus(wavefunction2.valueAt(i, j + 1)).plus(wavefunction2.valueAt(i, j - 1));
                wavefunction.setValue(i, j, complex.times(0.25));
            }
        }
    }

    public void reset() {
    }

    public Propagator copy() {
        return new AveragePropagator(this.getPotential());
    }

    public void setWavefunctionNorm(double d) {
    }

    public void setValue(int n, int n2, double d, double d2) {
    }
}

