/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.model.expectations;

import edu.colorado.phet.quantumwaveinterference.model.Wavefunction;
import edu.colorado.phet.quantumwaveinterference.model.math.Complex;

public class PxValue {
    public double compute(Wavefunction wavefunction) {
        Complex complex = new Complex();
        for (int i = 1; i < wavefunction.getWidth() - 1; ++i) {
            for (int j = 1; j < wavefunction.getHeight() - 1; ++j) {
                Complex complex2 = wavefunction.valueAt(i, j).complexConjugate();
                Complex complex3 = this.getOpPsi(wavefunction, i, j);
                Complex complex4 = complex2.times(complex3).times(new Complex(0.0, -1.0));
                complex = complex.plus(complex4);
            }
        }
        if (Math.abs(complex.getImaginary()) > 0.01) {
            new RuntimeException("imaginary part was substantial: c=" + complex).printStackTrace();
        }
        return complex.getReal();
    }

    private Complex getOpPsi(Wavefunction wavefunction, int n, int n2) {
        Complex complex = wavefunction.valueAt(n + 1, n2);
        Complex complex2 = wavefunction.valueAt(n - 1, n2);
        return complex.minus(complex2).times(0.5);
    }
}

