/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.model;

import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.quantumwaveinterference.model.Damping;
import edu.colorado.phet.quantumwaveinterference.model.Detector;
import edu.colorado.phet.quantumwaveinterference.model.DetectorSet;
import edu.colorado.phet.quantumwaveinterference.model.FractionalDoubleSlit;
import edu.colorado.phet.quantumwaveinterference.model.Potential;
import edu.colorado.phet.quantumwaveinterference.model.Propagator;
import edu.colorado.phet.quantumwaveinterference.model.Wave;
import edu.colorado.phet.quantumwaveinterference.model.WaveModel;
import edu.colorado.phet.quantumwaveinterference.model.WaveSetup;
import edu.colorado.phet.quantumwaveinterference.model.Wavefunction;
import edu.colorado.phet.quantumwaveinterference.model.potentials.CompositePotential;
import edu.colorado.phet.quantumwaveinterference.model.potentials.HorizontalDoubleSlit;
import edu.colorado.phet.quantumwaveinterference.model.propagators.ClassicalWavePropagator;
import edu.colorado.phet.quantumwaveinterference.model.propagators.ModifiedRichardsonPropagator;
import edu.colorado.phet.quantumwaveinterference.model.waves.ZeroWave;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class QWIModel
implements ModelElement {
    private WaveModel waveModel;
    private CompositePotential compositePotential;
    private WaveModel sourceWaveModel;
    private CompositePotential sourcePotential;
    private int timeStep;
    private double deltaTime;
    private Wave wave;
    private ArrayList listeners = new ArrayList();
    private DetectorSet detectorSet;
    private boolean detectionCausesCollapse = true;
    private Damping damping;
    private boolean paused = false;
    private WaveSetup initter;
    private HorizontalDoubleSlit doubleSlitPotential;
    private boolean doubleSlitEnabled;
    private boolean slitAbsorptive = true;
    private FractionalDoubleSlit fractionalDoubleSlit;

    public QWIModel() {
        this(100, 100);
    }

    public QWIModel(int n, int n2) {
        this(n, n2, 1.0E-5, QWIModel.createInitWave());
    }

    public QWIModel(int n, int n2, double d, Wave wave) {
        this.compositePotential = new CompositePotential();
        this.sourcePotential = new CompositePotential();
        this.deltaTime = d;
        this.wave = wave;
        this.waveModel = new WaveModel(new Wavefunction(n, n2), new ModifiedRichardsonPropagator(d, this.compositePotential, 1.0, 1.0));
        this.detectorSet = new DetectorSet(this.getWavefunction());
        this.initter = new WaveSetup(wave);
        this.initter.initialize(this.getWavefunction());
        this.sourceWaveModel = new WaveModel(new Wavefunction(n, n2), new ModifiedRichardsonPropagator(d, this.sourcePotential, 1.0, 1.0));
        this.addListener(this.detectorSet.getListener());
        this.damping = new Damping();
        this.doubleSlitPotential = this.createDoubleSlit();
        this.doubleSlitPotential.addListener(new HorizontalDoubleSlit.Listener(){

            public void slitChanged() {
                QWIModel.this.notifyPotentialChanged();
            }
        });
        this.fractionalDoubleSlit = this.createFractionalDoubleSlit();
    }

    private FractionalDoubleSlit createFractionalDoubleSlit() {
        return new FractionalDoubleSlit(this, 0.4, 0.05, 0.14, 0.25);
    }

    public FractionalDoubleSlit getFractionalDoubleSlit() {
        return this.fractionalDoubleSlit;
    }

    public Propagator getSourcePropagator() {
        return this.sourceWaveModel.getPropagator();
    }

    public Wavefunction getSourceWave() {
        return this.sourceWaveModel.getWavefunction();
    }

    public WaveModel getSourceWaveModel() {
        return this.sourceWaveModel;
    }

    protected static ZeroWave createInitWave() {
        return new ZeroWave();
    }

    public void setPropagatorClassical() {
        this.setPropagator(new ClassicalWavePropagator(this.compositePotential));
    }

    protected void step() {
        this.beforeTimeStep();
        this.getPropagationStrategy().step();
        this.incrementTimeStep();
        this.finishedTimeStep();
    }

    public void setBarrierAbsorptive(boolean bl) {
        this.slitAbsorptive = bl;
    }

    public boolean isBarrierAbsorptive() {
        return this.slitAbsorptive;
    }

    public boolean isAutoDetect() {
        return this.detectorSet.isAutoDetect();
    }

    public void clearAllWaves() {
        this.sourceWaveModel.clear();
        this.waveModel.clear();
    }

    public WaveModel getWaveModel() {
        return this.waveModel;
    }

    public void updateWavefunctionAfterDetection() {
        this.clearAllWaves();
    }

    public Map getModelParameters() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("lattice width", "" + this.getWavefunction().getWidth());
        hashMap.put("lattice height", "" + this.getWavefunction().getWidth());
        hashMap.putAll(this.getPropagator().getModelParameters());
        return hashMap;
    }

    public void gunFired() {
        this.detectorSet.gunFired();
    }

    public CompositePotential getCompositePotential() {
        return this.compositePotential;
    }

    public void debugSymmetry() {
        this.waveModel.debugSymmetry();
        this.doubleSlitPotential.debugSymmetry();
    }

    protected void defaultPropagate() {
        if (this.getWavefunction().getMagnitude() > 0.0) {
            this.getWaveModel().propagate();
            this.damping.damp(this.getWavefunction());
        }
    }

    protected void absorptivePropagate() {
        this.getWavefunction().setMagnitudeDirty();
        if (this.getWavefunction().getMagnitude() > 0.0) {
            this.getSourceWaveModel().propagate();
            this.copySourceToActualSouthArea();
            this.getWaveModel().propagate();
            this.damping.damp(this.getWavefunction());
            this.damping.damp(this.getSourceWave());
        }
    }

    protected PropagationStrategy getPropagationStrategy() {
        if (this.slitAbsorptive) {
            return new AbsorptivePropagate();
        }
        return new DefaultPropagate();
    }

    public void copyActualToSource() {
        for (int i = 0; i < this.getSourceWave().getHeight(); ++i) {
            for (int j = 0; j < this.getSourceWave().getWidth(); ++j) {
                this.copyActualToSource(j, i);
            }
        }
    }

    private void copyActualToSource(int n, int n2) {
        if (this.getPropagator() instanceof ClassicalWavePropagator && this.getSourcePropagator() instanceof ClassicalWavePropagator) {
            ClassicalWavePropagator classicalWavePropagator = (ClassicalWavePropagator)this.getPropagator();
            ClassicalWavePropagator classicalWavePropagator2 = (ClassicalWavePropagator)this.getSourcePropagator();
            if (classicalWavePropagator.getLast() != null && classicalWavePropagator2.getLast() != null) {
                classicalWavePropagator2.getLast().setValue(n, n2, classicalWavePropagator.getLast().valueAt(n, n2));
            }
            if (classicalWavePropagator.getLast2() != null && classicalWavePropagator2.getLast2() != null) {
                classicalWavePropagator2.getLast2().setValue(n, n2, classicalWavePropagator.getLast2().valueAt(n, n2));
            }
        }
        this.getSourceWave().setValue(n, n2, this.getWavefunction().valueAt(n, n2));
    }

    protected void copySourceToActualSouthArea() {
        int n;
        for (int i = n = this.getDoubleSlitPotential().getY() + this.getDoubleSlitPotential().getHeight(); i < this.getSourceWave().getHeight(); ++i) {
            for (int j = 0; j < this.getSourceWave().getWidth(); ++j) {
                this.copySourceToActual(j, i);
            }
        }
    }

    private void copySourceToActual(int n, int n2) {
        if (this.getPropagator() instanceof ClassicalWavePropagator && this.getSourcePropagator() instanceof ClassicalWavePropagator) {
            ClassicalWavePropagator classicalWavePropagator = (ClassicalWavePropagator)this.getPropagator();
            ClassicalWavePropagator classicalWavePropagator2 = (ClassicalWavePropagator)this.getSourcePropagator();
            if (classicalWavePropagator.getLast() != null && classicalWavePropagator2.getLast() != null) {
                classicalWavePropagator.getLast().setValue(n, n2, classicalWavePropagator2.getLast().valueAt(n, n2));
            }
            if (classicalWavePropagator.getLast2() != null && classicalWavePropagator2.getLast2() != null) {
                classicalWavePropagator.getLast2().setValue(n, n2, classicalWavePropagator2.getLast2().valueAt(n, n2));
            }
        }
        this.getWavefunction().setValue(n, n2, this.getSourceWave().valueAt(n, n2));
    }

    private HorizontalDoubleSlit createDoubleSlit() {
        return new HorizontalDoubleSlit(this.getGridWidth(), this.getGridHeight(), (int)((double)this.getGridHeight() * 0.4), 3, (int)((double)(8 * this.getGridWidth()) / 100.0), (int)((double)(13 * this.getGridWidth()) / 100.0), 1.7976931348623156E305);
    }

    protected void beforeTimeStep() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.beforeTimeStep(this);
        }
    }

    protected void incrementTimeStep() {
        ++this.timeStep;
    }

    protected void finishedTimeStep() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.finishedTimeStep(this);
        }
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void reset() {
        this.getSourceWave().clear();
        this.getWavefunction().clear();
        this.detectorSet.reset();
        this.getPropagator().reset();
        this.getSourcePropagator().reset();
        this.fractionalDoubleSlit.reset(0.4, 0.05, 0.14, 0.25, this.fractionalDoubleSlit.getPotential());
    }

    public int getGridWidth() {
        return this.getWavefunction().getWidth();
    }

    public int getGridHeight() {
        return this.getWavefunction().getHeight();
    }

    public Potential getPotential() {
        return this.compositePotential;
    }

    public void stepInTime(double d) {
        if (!this.paused) {
            this.step();
        }
    }

    public Wavefunction getWavefunction() {
        return this.waveModel.getWavefunction();
    }

    public int getTimeStep() {
        return this.timeStep;
    }

    public void fireParticle(WaveSetup waveSetup) {
        Wavefunction wavefunction = new Wavefunction(this.getGridWidth(), this.getGridHeight());
        waveSetup.initialize(wavefunction);
        this.getWavefunction().add(wavefunction);
        this.getSourceWave().add(wavefunction);
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.particleFired(this);
        }
    }

    public void setGridSize(int n, int n2) {
        if (n != this.getGridWidth() || n2 != this.getGridHeight()) {
            this.getWavefunction().setSize(n, n2);
            this.getSourceWave().setSize(n, n2);
            this.initter.initialize(this.getWavefunction());
            this.notifySizeChanged();
        }
    }

    private void notifySizeChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.sizeChanged();
        }
    }

    public double getDeltaTime() {
        return this.deltaTime;
    }

    public void setDeltaTime(double d) {
        this.deltaTime = d;
        this.getPropagator().setDeltaTime(this.deltaTime);
        this.getSourcePropagator().setDeltaTime(this.deltaTime);
    }

    public void addDetector(Detector detector) {
        this.detectorSet.addDetector(detector);
    }

    public void setDetectionCausesCollapse(boolean bl) {
        this.detectionCausesCollapse = bl;
    }

    public void addPotential(Potential potential) {
        this.compositePotential.addPotential(potential);
        this.updatePotential();
    }

    private void updatePotential() {
        this.sourcePotential.clear();
        for (int i = 0; i < this.compositePotential.numPotentials(); ++i) {
            Potential potential = this.compositePotential.potentialAt(i);
            if (potential == this.doubleSlitPotential) continue;
            this.sourcePotential.addPotential(potential);
        }
        this.notifyPotentialChanged();
    }

    private void notifyPotentialChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.potentialChanged();
        }
    }

    public void clearPotentialIgnoreSlits() {
        boolean bl = this.isDoubleSlitEnabled();
        this.setDoubleSlitEnabled(false);
        this.compositePotential.clear();
        this.setDoubleSlitEnabled(bl);
        if (this.isDoubleSlitEnabled() != bl) {
            this.notifySlitStateChanged();
        }
        this.updatePotential();
    }

    public double getSimulationTime() {
        return this.getPropagator().getSimulationTime();
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public void setPropagator(Propagator propagator) {
        this.getPropagator().deactivate();
        this.waveModel.setPropagator(propagator);
        this.sourceWaveModel.setPropagator(propagator.copy());
        this.sourceWaveModel.getPropagator().setPotential(this.sourcePotential);
        this.getPropagator().activate();
        this.notifyPropagatorChanged();
    }

    private void notifyPropagatorChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.propagatorChanged();
        }
    }

    public Propagator getPropagator() {
        return this.waveModel.getPropagator();
    }

    public Damping getDamping() {
        return this.damping;
    }

    public void removePotential(Potential potential) {
        this.compositePotential.removePotential(potential);
        this.updatePotential();
    }

    public void setAutoDetect(boolean bl) {
        this.detectorSet.setAutoDetect(bl);
    }

    public void detect() {
        this.detectorSet.fireAllEnabledDetectors();
    }

    public void enableAllDetectors() {
        this.detectorSet.enableAll();
    }

    public void removeDetector(Detector detector) {
        this.detectorSet.removeDetector(detector);
    }

    public void clearWavefunction() {
        this.sourceWaveModel.clear();
        this.waveModel.clear();
    }

    public void reduceWavefunctionNorm(double d) {
        if (d != 0.0) {
            double d2 = this.getWavefunction().getMagnitude();
            double d3 = d2 - d;
            double d4 = d3 <= 0.0 ? 0.0 : d3 / d2;
            this.getWavefunction().scale(d4);
            this.getSourceWave().scale(d4);
            if (this.getPropagator() instanceof ClassicalWavePropagator) {
                ClassicalWavePropagator classicalWavePropagator = (ClassicalWavePropagator)this.getPropagator();
                classicalWavePropagator.scale(d4);
            }
        }
    }

    public HorizontalDoubleSlit getDoubleSlitPotential() {
        return this.doubleSlitPotential;
    }

    public void setDoubleSlitEnabled(boolean bl) {
        if (this.isDoubleSlitEnabled() != bl) {
            if (!bl) {
                this.removePotential(this.doubleSlitPotential);
            } else if (bl) {
                this.addPotential(this.doubleSlitPotential);
            }
            this.doubleSlitEnabled = bl;
            this.notifySlitStateChanged();
        }
    }

    private void notifySlitStateChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.doubleSlitVisibilityChanged();
        }
    }

    public Wavefunction getDetectionRegion(int n, int n2, int n3, int n4) {
        return this.getWavefunction().copyRegion(0, n2, n3, n4);
    }

    public boolean containsListener(Listener listener) {
        return this.listeners.contains(listener);
    }

    public DetectorSet getDetectorSet() {
        return this.detectorSet;
    }

    public void setWavefunctionNorm(double d) {
        this.sourceWaveModel.setWavefunctionNorm(d);
        this.waveModel.setWavefunctionNorm(d);
    }

    public void setWaveSize(int n, int n2) {
        this.setGridSize(n, n2);
        this.clearWavefunction();
    }

    public Wave getBoundaryCondition() {
        return this.wave;
    }

    public boolean isDetectionCausesCollapse() {
        return this.detectionCausesCollapse;
    }

    public boolean containsDetector(Detector detector) {
        return this.detectorSet.containsDetector(detector);
    }

    public boolean isDoubleSlitEnabled() {
        return this.doubleSlitEnabled;
    }

    class AbsorptivePropagate
    implements PropagationStrategy {
        AbsorptivePropagate() {
        }

        public void step() {
            QWIModel.this.absorptivePropagate();
        }
    }

    public static class Adapter
    implements Listener {
        public void propagatorChanged() {
        }

        public void finishedTimeStep(QWIModel qWIModel) {
        }

        public void sizeChanged() {
        }

        public void potentialChanged() {
        }

        public void beforeTimeStep(QWIModel qWIModel) {
        }

        public void particleFired(QWIModel qWIModel) {
        }

        public void doubleSlitVisibilityChanged() {
        }
    }

    class DefaultPropagate
    implements PropagationStrategy {
        DefaultPropagate() {
        }

        public void step() {
            QWIModel.this.defaultPropagate();
        }
    }

    public static interface Listener {
        public void propagatorChanged();

        public void finishedTimeStep(QWIModel var1);

        public void sizeChanged();

        public void potentialChanged();

        public void beforeTimeStep(QWIModel var1);

        public void particleFired(QWIModel var1);

        public void doubleSlitVisibilityChanged();
    }

    public static interface PropagationStrategy {
        public void step();
    }
}

