/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.model;

import edu.colorado.phet.quantumwaveinterference.model.Potential;
import edu.colorado.phet.quantumwaveinterference.model.Wavefunction;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public abstract class Propagator {
    private double simulationTime;
    private double deltaTime;
    private Potential potential;
    private ArrayList listeners = new ArrayList();

    public void deactivate() {
    }

    public void activate() {
    }

    protected Propagator(Potential potential) {
        this.potential = potential;
    }

    public abstract void propagate(Wavefunction var1);

    public void setDeltaTime(double d) {
        this.deltaTime = d;
        this.notifyDeltaTimeChanged();
    }

    private void notifyDeltaTimeChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.deltaTimeChanged(this);
        }
    }

    public double getSimulationTime() {
        return this.simulationTime;
    }

    public abstract void reset();

    public abstract Propagator copy();

    public abstract void setWavefunctionNorm(double var1);

    public void setPotential(Potential potential) {
        this.potential = potential;
    }

    public double getDeltaTime() {
        return this.deltaTime;
    }

    public Potential getPotential() {
        return this.potential;
    }

    public void copyTo(int n, int n2, Propagator propagator) {
    }

    public void clearWave(Rectangle rectangle) {
    }

    public void splitWave(Rectangle rectangle, Propagator propagator, Propagator propagator2) {
    }

    public void combineWaves(Rectangle rectangle, Propagator propagator, Propagator propagator2) {
    }

    public Map getModelParameters() {
        return new HashMap();
    }

    public abstract void setValue(int var1, int var2, double var3, double var5);

    public static interface Listener {
        public void deltaTimeChanged(Propagator var1);
    }
}

