/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.model;

import edu.colorado.phet.quantumwaveinterference.model.Detector;
import edu.colorado.phet.quantumwaveinterference.model.QWIModel;
import edu.colorado.phet.quantumwaveinterference.model.Wavefunction;
import java.util.ArrayList;
import java.util.Collections;

public class DetectorSet {
    private ArrayList detectors = new ArrayList();
    private QWIModel.Listener listener;
    private Wavefunction wavefunction;
    private boolean autodetect = true;
    private boolean repeats = false;
    private boolean oneShot = true;
    private ArrayList listeners = new ArrayList();

    public DetectorSet(Wavefunction wavefunction) {
        this.wavefunction = wavefunction;
        this.listener = new AutoDetectAdapter();
    }

    public void reset() {
        for (int i = 0; i < this.detectors.size(); ++i) {
            Detector detector = (Detector)this.detectors.get(i);
            detector.reset();
        }
    }

    public void addDetector(Detector detector) {
        this.detectors.add(detector);
    }

    public void updateDetectorProbabilities() {
        for (int i = 0; i < this.detectors.size(); ++i) {
            Detector detector = (Detector)this.detectors.get(i);
            detector.updateProbability(this.getWavefunction());
        }
    }

    public void fireAllEnabledDetectors() {
        this.fireAllEnabledDetectors(new FireEnabled());
    }

    public boolean containsDetector(Detector detector) {
        return this.detectors.contains(detector);
    }

    public boolean isAutoDetect() {
        return this.autodetect;
    }

    public void gunFired() {
        this.enableAll();
    }

    public int numDetectors() {
        return this.detectors.size();
    }

    public Detector detectorAt(int n) {
        return (Detector)this.detectors.get(n);
    }

    public void setOneShot(boolean bl) {
        this.oneShot = bl;
    }

    public boolean isOneShot() {
        return this.oneShot;
    }

    private void fireAllEnabledDetectors(FireStrategy fireStrategy) {
        double d = 1.0;
        if (this.getWavefunction().getMagnitude() > 0.0) {
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(this.detectors);
            Collections.shuffle(arrayList);
            for (int i = 0; i < arrayList.size(); ++i) {
                boolean bl;
                Detector detector = (Detector)arrayList.get(i);
                if (!detector.isEnabled() || !(bl = fireStrategy.tryToGrab(detector, this.getWavefunction(), d))) continue;
                if (!this.oneShot) break;
                detector.setEnabled(false);
                break;
            }
        }
        if (this.detectors.size() > 0) {
            this.notifyDetectionFinished();
        }
    }

    private Wavefunction getWavefunction() {
        return this.wavefunction;
    }

    public QWIModel.Listener getListener() {
        return this.listener;
    }

    private void notifyTimeStepped() {
        for (int i = 0; i < this.detectors.size(); ++i) {
            Detector detector = (Detector)this.detectors.get(i);
            detector.notifyTimeStepped();
        }
    }

    public void setAutoDetect(boolean bl) {
        this.autodetect = bl;
    }

    public void enableAll() {
        for (int i = 0; i < this.detectors.size(); ++i) {
            Detector detector = (Detector)this.detectors.get(i);
            detector.setEnabled(true);
        }
    }

    public void removeDetector(Detector detector) {
        this.detectors.remove(detector);
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void notifyDetectionFinished() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.detectionAttempted();
        }
    }

    private class AutoDetect
    implements FireStrategy {
        private AutoDetect() {
        }

        public boolean tryToGrab(Detector detector, Wavefunction wavefunction, double d) {
            boolean bl = false;
            if (detector.timeToFire()) {
                bl = detector.tryToGrab(wavefunction, d);
            }
            return bl;
        }
    }

    public class AutoDetectAdapter
    extends QWIModel.Adapter {
        public void finishedTimeStep(QWIModel qWIModel) {
            DetectorSet.this.notifyTimeStepped();
            DetectorSet.this.updateDetectorProbabilities();
            if (DetectorSet.this.autodetect && qWIModel.isDetectionCausesCollapse()) {
                DetectorSet.this.fireAllEnabledDetectors(new AutoDetect());
            }
        }
    }

    private class FireEnabled
    implements FireStrategy {
        private FireEnabled() {
        }

        public boolean tryToGrab(Detector detector, Wavefunction wavefunction, double d) {
            return detector.tryToGrab(wavefunction, d);
        }
    }

    private static interface FireStrategy {
        public boolean tryToGrab(Detector var1, Wavefunction var2, double var3);
    }

    public static interface Listener {
        public void detectionAttempted();
    }
}

