/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.model;

import edu.colorado.phet.quantumwaveinterference.model.QWIModel;
import edu.colorado.phet.quantumwaveinterference.model.RectangularObject;
import edu.colorado.phet.quantumwaveinterference.model.Wavefunction;
import edu.colorado.phet.quantumwaveinterference.model.math.Complex;
import edu.colorado.phet.quantumwaveinterference.model.propagators.ClassicalWavePropagator;
import java.awt.Rectangle;
import java.util.Random;

public class Detector
extends RectangularObject {
    private double probability;
    private boolean enabled = true;
    private int numTimeStepsBetweenDetect = 10;
    private int timeSinceLast = 0;
    private static final Random random = new Random();
    private QWIModel QWIModel;
    private static double probabilityScaleFudgeFactor = 5.0;

    public static void setProbabilityScaleFudgeFactor(double d) {
        probabilityScaleFudgeFactor = d;
    }

    public Detector(QWIModel qWIModel, int n, int n2, int n3, int n4) {
        super(qWIModel, n, n2, n3, n4);
        this.QWIModel = qWIModel;
    }

    public void setSize(int n, int n2) {
        super.setSize(n, n2);
        this.numTimeStepsBetweenDetect = (n + n2) / 2;
    }

    public void updateProbability(Wavefunction wavefunction) {
        double d = this.probability;
        if (!this.enabled) {
            return;
        }
        double d2 = 0.0;
        for (int i = super.getX(); i < this.getX() + this.getWidth(); ++i) {
            for (int j = super.getY(); j < this.getY() + this.getHeight(); ++j) {
                if (!wavefunction.containsLocation(i, j)) continue;
                Complex complex = wavefunction.valueAt(i, j).complexConjugate();
                Complex complex2 = wavefunction.valueAt(i, j);
                Complex complex3 = complex.times(complex2);
                d2 += complex3.abs();
            }
        }
        this.probability = d2;
        if (Double.isNaN(this.probability)) {
            this.probability = 0.0;
        }
        if (d != this.probability) {
            this.notifyObservers();
        }
    }

    public boolean timeToFire() {
        return this.timeSinceLast >= this.numTimeStepsBetweenDetect;
    }

    public double getProbability() {
        return this.probability;
    }

    public void setEnabled(boolean bl) {
        if (this.enabled != bl) {
            this.enabled = bl;
            if (!this.enabled) {
                this.probability = 0.0;
            }
            this.notifyObservers();
        }
    }

    public void reset() {
        this.setEnabled(true);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    private void zero(Wavefunction wavefunction) {
        for (int i = this.getX(); i < this.getMaxX(); ++i) {
            for (int j = this.getY(); j < this.getMaxY(); ++j) {
                if (!wavefunction.containsLocation(i, j)) continue;
                wavefunction.valueAt(i, j).zero();
            }
        }
    }

    public void zeroElsewhere(Wavefunction wavefunction) {
        for (int i = 0; i < wavefunction.getWidth(); ++i) {
            for (int j = 0; j < wavefunction.getHeight(); ++j) {
                if (this.contains(i, j) || !wavefunction.containsLocation(i, j)) continue;
                wavefunction.valueAt(i, j).zero();
            }
        }
    }

    private int getMaxY() {
        return this.getY() + this.getHeight();
    }

    private int getMaxX() {
        return this.getX() + this.getWidth();
    }

    public void notifyTimeStepped() {
        ++this.timeSinceLast;
    }

    public boolean tryToGrab(Wavefunction wavefunction, double d) {
        boolean bl = false;
        double d2 = this.getProbability() * probabilityScaleFudgeFactor;
        double d3 = random.nextDouble() * d;
        if (d3 <= d2) {
            this.grabWavefunction(wavefunction);
            bl = true;
        } else {
            this.expelWavefunction(wavefunction);
        }
        this.QWIModel.copyActualToSource();
        this.timeSinceLast = 0;
        return bl;
    }

    private void expelWavefunction(Wavefunction wavefunction) {
        ClassicalWavePropagator classicalWavePropagator;
        double d = wavefunction.getMagnitude();
        this.zero(wavefunction);
        if (this.QWIModel.getPropagator() instanceof ClassicalWavePropagator && (classicalWavePropagator = (ClassicalWavePropagator)this.QWIModel.getPropagator()).getLast2() != null) {
            this.zero(classicalWavePropagator.getLast());
            this.zero(classicalWavePropagator.getLast2());
        }
        wavefunction.setMagnitude(d);
    }

    private void grabWavefunction(Wavefunction wavefunction) {
        ClassicalWavePropagator classicalWavePropagator;
        this.zeroElsewhere(wavefunction);
        wavefunction.normalize();
        if (this.QWIModel.getPropagator() instanceof ClassicalWavePropagator && (classicalWavePropagator = (ClassicalWavePropagator)this.QWIModel.getPropagator()).getLast2() != null) {
            this.zeroElsewhere(classicalWavePropagator.getLast());
            this.zeroElsewhere(classicalWavePropagator.getLast2());
            classicalWavePropagator.getLast().normalize();
            classicalWavePropagator.getLast2().normalize();
        }
    }

    public boolean contains(int n, int n2) {
        return this.getBounds().contains(n, n2);
    }

    public void setRect(Rectangle rectangle) {
        this.setSize(rectangle.width, rectangle.height);
        this.setLocation(rectangle.x, rectangle.y);
    }

    public static double getProbabilityScaleFudgeFactor() {
        return probabilityScaleFudgeFactor;
    }

    static {
        Detector.setProbabilityScaleFudgeFactor(probabilityScaleFudgeFactor);
    }
}

