/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.davissongermer;

import edu.colorado.phet.quantumwaveinterference.QWIResources;
import edu.colorado.phet.quantumwaveinterference.davissongermer.ConstrainedSliderControl;
import edu.colorado.phet.quantumwaveinterference.davissongermer.CoordinateFrame;
import edu.colorado.phet.quantumwaveinterference.davissongermer.DGModel;
import java.text.DecimalFormat;

public class RadiusControl
extends ConstrainedSliderControl {
    private DGModel dgModel;

    public double getModelValue() {
        return this.dgModel.getFractionalRadius();
    }

    public void setModelValue(double d) {
        this.dgModel.setFractionalRadius(d);
    }

    private static int getNumSliderValues(CoordinateFrame coordinateFrame) {
        return 5;
    }

    public RadiusControl(DGModel dGModel) {
        double d;
        double d2;
        double d3;
        this.dgModel = dGModel;
        this.init(QWIResources.getString("atom.radius"), new DecimalFormat("0.00"), dGModel.getRadiusModelFrame(), dGModel.getRadiusViewFrame(), new CoordinateFrame(0.0, RadiusControl.getNumSliderValues(dGModel.getRadiusViewFrame()) - 1));
        dGModel.addListener(new DGModel.Listener(){

            public void potentialChanged() {
                RadiusControl.this.update();
            }
        });
        this.update();
        CoordinateFrame coordinateFrame = this.getSliderFrame();
        System.out.println("Converting slider values:");
        for (d3 = coordinateFrame.getMin(); d3 <= coordinateFrame.getMax(); d3 += 1.0) {
            d2 = this.transform(d3, coordinateFrame, this.getViewFrame());
            d = this.transform(d3, coordinateFrame, this.getModelFrame());
            System.out.println("slider value = " + d3 + ", view=" + d2 + ", fraction of lattice=" + d + ", cells on lattice=" + RadiusControl.modelFractionToNumCells(d) + " chopped=" + (int)RadiusControl.modelFractionToNumCells(d));
        }
        System.out.println("Converting view values:");
        for (d3 = this.getViewFrame().getMin(); d3 <= this.getViewFrame().getMax(); d3 += 0.05) {
            d2 = this.transform(d3, this.getViewFrame(), this.getModelFrame());
            d = this.transform(d3, this.getViewFrame(), this.getSliderFrame());
            System.out.println("view value = " + d3 + ", slider value=" + d + ", fraction of lattice=" + d2 + ", cells on lattice=" + RadiusControl.modelFractionToNumCells(d2) + ", chopped=" + (int)RadiusControl.modelFractionToNumCells(d2));
        }
    }

    public static double modelFractionToNumCells(double d) {
        return d * 45.0;
    }
}

