/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.davissongermer;

import edu.colorado.phet.common.phetcommon.application.PaintImmediateDialog;
import edu.colorado.phet.common.phetcommon.view.HorizontalLayoutPanel;
import edu.colorado.phet.quantumwaveinterference.davissongermer.DGModule;
import edu.colorado.phet.quantumwaveinterference.davissongermer.DGPlotPanel;
import edu.colorado.phet.quantumwaveinterference.davissongermer.SaveDGPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.JButton;
import javax.swing.JPanel;

public class DGPlotFrame
extends PaintImmediateDialog {
    private DGPlotPanel dgPlotPanel;
    private Frame owner;
    private DGModule dgModule;

    public DGPlotFrame(Frame frame, DGModule dGModule) {
        super(frame, "Intensity Plot", false);
        this.owner = frame;
        this.dgModule = dGModule;
        this.dgPlotPanel = new DGPlotPanel(dGModule);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.dgPlotPanel, "Center");
        DGPlotControlPanel dGPlotControlPanel = new DGPlotControlPanel(this);
        jPanel.add((Component)dGPlotControlPanel, "South");
        this.setContentPane(jPanel);
        this.pack();
    }

    public void setVisible(boolean bl) {
        this.dgPlotPanel.visibilityChanged(bl);
        super.setVisible(bl);
    }

    private Frame getOwnerFrame() {
        return this.owner;
    }

    public DGPlotPanel getDgPlotPanel() {
        return this.dgPlotPanel;
    }

    static class DGPlotControlPanel
    extends HorizontalLayoutPanel {
        private SaveDGPanel saveDGPanel = new SaveDGPanel();

        public DGPlotControlPanel(final DGPlotFrame dGPlotFrame) {
            JButton jButton = new JButton("Save Snapshot");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    double d = dGPlotFrame.dgModule.getDGSchrodingerPanel().getDGGunGraphic().getDgParticle().getSliderFraction();
                    double d2 = 0.6666666666666666;
                    double d3 = (d + 1.0) * d2;
                    DecimalFormat decimalFormat = new DecimalFormat("0.00");
                    double d4 = dGPlotFrame.dgModule.getVelocityRealUnits();
                    String string = "v=" + new DecimalFormat("0").format(d4) + " km/s, D=" + new DecimalFormat("0.0").format(dGPlotFrame.dgModule.getSpacing()) + " nm";
                    DGPlotControlPanel.this.saveDGPanel.savePanel(dGPlotFrame.getDgPlotPanel(), dGPlotFrame.getOwnerFrame(), string);
                }
            });
            this.setFill(0);
            this.add(jButton);
            JButton jButton2 = new JButton("Clear Snapshots");
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    dGPlotFrame.getDgPlotPanel().clearSnapshots();
                }
            });
            this.add(jButton2);
        }
    }
}

