/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.davissongermer;

import edu.colorado.phet.quantumwaveinterference.QWIResources;
import edu.colorado.phet.quantumwaveinterference.model.ParticleUnits;
import java.text.DecimalFormat;

public class DGParticleUnits
extends ParticleUnits {
    public DGParticleUnits() {
        this.setHbar(new ParticleUnits.Value(0.658, 1.0, QWIResources.getString("ev.fs")));
        this.setMass(new ParticleUnits.Value(0.057, 100.0, QWIResources.getString("ev.fs.2.nm.2")));
        this.setDx(new ParticleUnits.Value(1.0, 0.1, QWIResources.getString("nm")));
        this.setDt(new ParticleUnits.Value(0.05, 0.1, QWIResources.getString("fs")));
        double d = 100.0;
        this.setMinVelocity(new ParticleUnits.Value(700.0 / d, d, QWIResources.getString("gun.km-s")));
        this.setMaxVelocity(new ParticleUnits.Value(1500.0 / d * 4.0 * 1840.0 / 6000.0, d, QWIResources.getString("gun.km-s")));
        DecimalFormat decimalFormat = new DecimalFormat("0");
        this.setVelocityFormat(decimalFormat);
        this.setTimeScaleFactor(10.0);
    }
}

