/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.davissongermer;

import edu.colorado.phet.common.phetcommon.view.ControlPanel;
import edu.colorado.phet.common.phetcommon.view.ModelSlider;
import edu.colorado.phet.quantumwaveinterference.QWIResources;
import edu.colorado.phet.quantumwaveinterference.controls.ClearButton;
import edu.colorado.phet.quantumwaveinterference.controls.RulerPanel;
import edu.colorado.phet.quantumwaveinterference.davissongermer.AtomLatticeControlPanel;
import edu.colorado.phet.quantumwaveinterference.davissongermer.AtomShapeControlPanel;
import edu.colorado.phet.quantumwaveinterference.davissongermer.DGGun;
import edu.colorado.phet.quantumwaveinterference.davissongermer.DGModule;
import edu.colorado.phet.quantumwaveinterference.davissongermer.DGParticle;
import edu.colorado.phet.quantumwaveinterference.davissongermer.DGReaderControlPanel;
import edu.colorado.phet.quantumwaveinterference.view.gun.AbstractGunNode;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.JCheckBox;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DGControlPanel
extends ControlPanel {
    private DGModule dgModule;
    private boolean addExtraControls = false;

    public DGControlPanel(DGModule dGModule) {
        this.dgModule = dGModule;
        this.addRulerPanel();
        this.addProtractorPanel();
        this.addControl(new ClearButton(dGModule.getSchrodingerPanel()));
        final JCheckBox jCheckBox = new JCheckBox(QWIResources.getString("plot"));
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DGControlPanel.this.setPlotVisible(jCheckBox.isSelected());
            }
        });
        this.addControl(jCheckBox);
        this.addControlFullWidth(new AtomLatticeControlPanel(dGModule.getDGModel()));
        if (this.addExtraControls) {
            this.addExtraControls(dGModule);
        }
        dGModule.getPlotFrame().addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                jCheckBox.setSelected(false);
            }
        });
    }

    private void addExtraControls(DGModule dGModule) {
        AbstractGunNode abstractGunNode = dGModule.getSchrodingerPanel().getSchrodingerScreenNode().getGunGraphic();
        if (abstractGunNode instanceof DGGun) {
            DGGun dGGun = (DGGun)abstractGunNode;
            final DGParticle dGParticle = dGGun.getDgParticle();
            final ModelSlider modelSlider = new ModelSlider(QWIResources.getString("covariance"), "", 0.0, 0.3, dGParticle.getCovariance());
            modelSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    dGParticle.setCovariance(modelSlider.getValue());
                }
            });
            this.addControl(modelSlider);
            final ModelSlider modelSlider2 = new ModelSlider(QWIResources.getString("particle.y0"), "", 0.0, 1.0, dGParticle.getStartYFraction());
            modelSlider2.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    dGParticle.setStartYFraction(modelSlider2.getValue());
                }
            });
            this.addControl(modelSlider2);
        }
        this.addControlFullWidth(new AtomShapeControlPanel(dGModule));
        this.addControlFullWidth(new DGReaderControlPanel(dGModule));
    }

    private void setPlotVisible(boolean bl) {
        this.dgModule.getPlotFrame().setVisible(bl);
    }

    private void addRulerPanel() {
        try {
            RulerPanel rulerPanel = new RulerPanel(this.dgModule.getSchrodingerPanel());
            this.addControl(rulerPanel);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void addProtractorPanel() {
        final JCheckBox jCheckBox = new JCheckBox(QWIResources.getString("protractor"), false);
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DGControlPanel.this.dgModule.setProtractorVisible(jCheckBox.isSelected());
            }
        });
        this.addControl(jCheckBox);
    }
}

