/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.davissongermer;

import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.quantumwaveinterference.QWIResources;
import edu.colorado.phet.quantumwaveinterference.davissongermer.CoordinateFrame;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public abstract class ConstrainedSliderControl
extends VerticalLayoutPanel {
    private Font titleFont = new PhetFont(1, 12);
    private JSlider slider;
    private CoordinateFrame modelFrame;
    private CoordinateFrame viewFrame;
    private CoordinateFrame sliderFrame;
    private DecimalFormat format;
    private JLabel titleLabel;
    private String title;

    public void init(String string, DecimalFormat decimalFormat, CoordinateFrame coordinateFrame, CoordinateFrame coordinateFrame2, CoordinateFrame coordinateFrame3) {
        this.title = string;
        this.modelFrame = coordinateFrame;
        this.viewFrame = coordinateFrame2;
        this.sliderFrame = coordinateFrame3;
        this.format = decimalFormat;
        this.titleLabel = new JLabel(string){

            protected void paintComponent(Graphics graphics) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                super.paintComponent(graphics);
            }
        };
        this.titleLabel.setFont(this.titleFont);
        this.setAnchor(17);
        this.setFillNone();
        this.add(this.titleLabel);
        this.slider = new JSlider(0, this.getNumSliderValues() - 1, (int)this.transform(this.getModelValue(), coordinateFrame, coordinateFrame3));
        this.slider.setPaintLabels(true);
        this.slider.setPaintTrack(true);
        this.slider.setPaintTicks(true);
        this.slider.setMajorTickSpacing(4);
        this.slider.setMinorTickSpacing(1);
        this.slider.setSnapToTicks(true);
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        System.out.println("getNumSliderValues() = " + this.getNumSliderValues());
        for (int i = 0; i <= this.getNumSliderValues() - 1; ++i) {
            hashtable.put(new Integer(i), new JLabel(decimalFormat.format(this.transform(i, coordinateFrame3, coordinateFrame2))));
        }
        this.slider.setLabelTable(hashtable);
        this.addFullWidth(this.slider);
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setFillNone();
        this.slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ConstrainedSliderControl.this.changeValue();
            }
        });
        this.update();
    }

    protected double determineModelValue() {
        return this.transform(this.getSlider().getValue(), this.getSliderFrame(), this.getModelFrame());
    }

    private int getNumSliderValues() {
        return (int)Math.round(this.sliderFrame.getRange()) + 1;
    }

    public JSlider getSlider() {
        return this.slider;
    }

    protected double transform(double d, CoordinateFrame coordinateFrame, CoordinateFrame coordinateFrame2) {
        return coordinateFrame.transform(d, coordinateFrame2);
    }

    public abstract double getModelValue();

    public abstract void setModelValue(double var1);

    private void changeValue() {
        this.setModelValue(this.determineModelValue());
    }

    public void update() {
        this.slider.setValue((int)Math.round(this.transform(this.getModelValue(), this.modelFrame, this.sliderFrame)));
        String string = "" + this.format.format(this.transform(this.getModelValue(), this.modelFrame, this.viewFrame));
        this.titleLabel.setText(MessageFormat.format(QWIResources.getString("0.1.nm"), this.title, string));
    }

    public CoordinateFrame getModelFrame() {
        return this.modelFrame;
    }

    public CoordinateFrame getViewFrame() {
        return this.viewFrame;
    }

    public CoordinateFrame getSliderFrame() {
        return this.sliderFrame;
    }
}

