/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.controls;

import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.quantumwaveinterference.QWIResources;
import edu.colorado.phet.quantumwaveinterference.model.QWIModel;
import edu.colorado.phet.quantumwaveinterference.modules.intensity.IntensityModule;
import edu.colorado.phet.quantumwaveinterference.view.QWIPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;

public class SlitDetectorPanel
extends VerticalLayoutPanel {
    private IntensityModule intensityModule;
    private JCheckBox leftSlit;
    private JCheckBox rightSlit;

    public SlitDetectorPanel(final IntensityModule intensityModule) {
        this.intensityModule = intensityModule;
        this.leftSlit = new JCheckBox(QWIResources.getString("controls.slits.left-detector"));
        this.leftSlit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                intensityModule.setLeftDetectorEnabled(SlitDetectorPanel.this.leftSlit.isSelected());
            }
        });
        this.add(this.leftSlit);
        this.rightSlit = new JCheckBox(QWIResources.getString("controls.slits.right-detector"));
        this.rightSlit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                intensityModule.setRightDetectorEnabled(SlitDetectorPanel.this.rightSlit.isSelected());
            }
        });
        this.add(this.rightSlit);
        intensityModule.getSchrodingerPanel().addListener(new QWIPanel.Adapter(){

            public void inverseSlitsChanged() {
                SlitDetectorPanel.this.setButtonsEnabled(!SlitDetectorPanel.this.isInverseSlits());
            }
        });
        intensityModule.addListener(new IntensityModule.Adapter(){

            public void detectorsChanged() {
                SlitDetectorPanel.this.leftSlit.setSelected(intensityModule.isLeftDetectorEnabled());
                SlitDetectorPanel.this.rightSlit.setSelected(intensityModule.isRightDetectorEnabled());
            }
        });
        intensityModule.getQWIModel().addListener(new QWIModel.Adapter(){

            public void doubleSlitVisibilityChanged() {
                SlitDetectorPanel.this.synchronizeModelState();
            }
        });
    }

    private boolean isInverseSlits() {
        return this.intensityModule.getSchrodingerPanel().isInverseSlits();
    }

    private void setButtonsEnabled(boolean bl) {
        this.rightSlit.setEnabled(bl);
        this.leftSlit.setEnabled(bl);
    }

    public void synchronizeModelState() {
        this.intensityModule.setRightDetectorEnabled(this.rightSlit.isSelected());
        this.intensityModule.setLeftDetectorEnabled(this.leftSlit.isSelected());
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.leftSlit.setEnabled(bl);
        this.rightSlit.setEnabled(bl);
    }
}

