/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.controls;

import edu.colorado.phet.common.phetcommon.view.AdvancedPanel;
import edu.colorado.phet.quantumwaveinterference.QWIModule;
import edu.colorado.phet.quantumwaveinterference.QWIResources;
import edu.colorado.phet.quantumwaveinterference.view.piccolo.QWIScreenNode;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ResolutionControl
extends AdvancedPanel {
    private QWIModule qwiModule;
    private final int WAVE_GRAPHIC_SIZE_1024x768 = 360;
    public static int INIT_WAVE_SIZE = 0;

    public ResolutionControl(final QWIModule qWIModule) {
        super(QWIResources.getString("resolution1"), QWIResources.getString("resolution2"));
        this.qwiModule = qWIModule;
        final JSpinner jSpinner = new JSpinner(new SpinnerNumberModel(60, 10, 1024, 5));
        this.getSchrodingerModule().setWaveSize(60);
        jSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                Integer n = (Integer)jSpinner.getValue();
                ResolutionControl.this.getSchrodingerModule().setWaveSize(n);
            }
        });
        final JComboBox<ResolutionSetup> jComboBox = new JComboBox<ResolutionSetup>(QWIModule.getResolutionSetups());
        jComboBox.setSelectedItem(new Integer(qWIModule.getSchrodingerPanel().getSchrodingerScreenNode().getCellSize()));
        this.addControl(new JLabel(QWIResources.getString("menus.resolution")));
        this.addControl(jComboBox);
        jComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResolutionSetup resolutionSetup = (ResolutionSetup)jComboBox.getSelectedItem();
                ResolutionControl.this.getSchrodingerModule().setResolution(resolutionSetup);
                qWIModule.setCellSize(resolutionSetup.intValue());
                int n = 360 / resolutionSetup.intValue();
                ResolutionControl.this.getSchrodingerModule().setWaveSize(n);
            }
        });
        INIT_WAVE_SIZE = 360 / qWIModule.getSchrodingerPanel().getSchrodingerScreenNode().getCellSize();
        this.getSchrodingerModule().setWaveSize(INIT_WAVE_SIZE);
        JLabel jLabel = new JLabel(QWIResources.getString("menus.time-step"));
        this.addControl(jLabel);
        final JSpinner jSpinner2 = new JSpinner(new SpinnerNumberModel(QWIScreenNode.numIterationsBetwenScreenUpdate, 1, 20, 1));
        jSpinner2.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                Integer n = (Integer)jSpinner2.getValue();
                QWIScreenNode.numIterationsBetwenScreenUpdate = n;
            }
        });
        this.addControl(jSpinner2);
    }

    private QWIModule getSchrodingerModule() {
        return this.qwiModule;
    }

    public static class ResolutionSetup {
        int value;
        String name;
        double timeFudgeFactorForLight;
        private double timeFudgeFactorForParticles;

        public ResolutionSetup(int n, String string, double d, double d2) {
            this.value = n;
            this.name = string;
            this.timeFudgeFactorForLight = d;
            this.timeFudgeFactorForParticles = d2;
        }

        public String toString() {
            return this.name;
        }

        public int intValue() {
            return this.value;
        }

        public double getTimeFudgeFactorForLight() {
            return this.timeFudgeFactorForLight;
        }

        public double getTimeFudgeFactorForParticles() {
            return this.timeFudgeFactorForParticles;
        }
    }
}

