/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.controls;

import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.quantumwaveinterference.QWIResources;
import edu.colorado.phet.quantumwaveinterference.controls.IVisualizationPanel;
import edu.colorado.phet.quantumwaveinterference.view.QWIPanel;
import edu.colorado.phet.quantumwaveinterference.view.colormaps.WaveValueAccessor;
import edu.colorado.phet.quantumwaveinterference.view.complexcolormaps.ComplexColorMap;
import edu.colorado.phet.quantumwaveinterference.view.complexcolormaps.GrayscaleColorMap;
import edu.colorado.phet.quantumwaveinterference.view.complexcolormaps.MagnitudeColorMap;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;

public class PhotonVisualizationPanel
extends VerticalLayoutPanel
implements IVisualizationPanel {
    private QWIPanel QWIPanel;
    private IVisualizationPanel.VisButton grayMag;
    private IVisualizationPanel.VisButton realGray;
    private IVisualizationPanel.VisButton[] visButton;

    public PhotonVisualizationPanel(QWIPanel qWIPanel) {
        this.QWIPanel = qWIPanel;
        this.setBorder(BorderFactory.createTitledBorder(QWIResources.getString("controls.em-wave-display")));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.grayMag = this.createVisualizationButton(QWIResources.getString("controls.em-wave-display.intensity"), new MagnitudeColorMap(), new WaveValueAccessor.Magnitude(), true, buttonGroup);
        this.addFullWidth(this.grayMag);
        this.realGray = this.createVisualizationButton(QWIResources.getString("controls.em-wave-display.e-field"), new GrayscaleColorMap.Real(), new WaveValueAccessor.Real(), false, buttonGroup);
        this.addFullWidth(this.realGray);
        this.visButton = new IVisualizationPanel.VisButton[]{this.grayMag, this.realGray};
    }

    private IVisualizationPanel.VisButton createVisualizationButton(String string, final ComplexColorMap complexColorMap, final WaveValueAccessor waveValueAccessor, boolean bl, ButtonGroup buttonGroup) {
        IVisualizationPanel.VisButton visButton = new IVisualizationPanel.VisButton(string, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PhotonVisualizationPanel.this.QWIPanel.setVisualizationStyle(complexColorMap, waveValueAccessor);
            }
        });
        buttonGroup.add(visButton);
        visButton.setSelected(bl);
        return visButton;
    }

    public Component getPanel() {
        return this;
    }

    public void applyChanges() {
        for (int i = 0; i < this.visButton.length; ++i) {
            IVisualizationPanel.VisButton visButton = this.visButton[i];
            if (!visButton.isSelected()) continue;
            visButton.fireEvent();
        }
    }
}

