/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.controls;

import edu.colorado.phet.common.phetcommon.view.AdvancedPanel;
import edu.colorado.phet.quantumwaveinterference.QWIModule;
import edu.colorado.phet.quantumwaveinterference.QWIResources;
import edu.colorado.phet.quantumwaveinterference.controls.DoubleSlitControlPanel;
import edu.colorado.phet.quantumwaveinterference.model.QWIModel;

public class ExpandableDoubleSlitPanel
extends AdvancedPanel {
    private QWIModule module;

    public ExpandableDoubleSlitPanel(QWIModule qWIModule) {
        super(QWIResources.getString("controls.slits.show"), QWIResources.getString("controls.slits.hide"));
        this.module = qWIModule;
        this.addControlFullWidth(new DoubleSlitControlPanel(qWIModule.getQWIModel(), qWIModule));
        this.addListener(new AdvancedPanel.Listener(){

            public void advancedPanelHidden(AdvancedPanel advancedPanel) {
                ExpandableDoubleSlitPanel.this.getDiscreteModel().setDoubleSlitEnabled(false);
            }

            public void advancedPanelShown(AdvancedPanel advancedPanel) {
                ExpandableDoubleSlitPanel.this.getDiscreteModel().setDoubleSlitEnabled(true);
            }
        });
        this.getDiscreteModel().addListener(new QWIModel.Adapter(){

            public void doubleSlitVisibilityChanged() {
                if (ExpandableDoubleSlitPanel.this.getDiscreteModel().isDoubleSlitEnabled()) {
                    ExpandableDoubleSlitPanel.this.showAdvanced();
                } else {
                    ExpandableDoubleSlitPanel.this.hideAdvanced();
                }
            }
        });
    }

    private QWIModel getDiscreteModel() {
        return this.module.getQWIModel();
    }
}

