/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference.controls;

import edu.colorado.phet.common.phetcommon.view.HorizontalLayoutPanel;
import edu.colorado.phet.common.phetcommon.view.ModelSlider;
import edu.colorado.phet.common.phetcommon.view.VerticalLayoutPanel;
import edu.colorado.phet.quantumwaveinterference.QWIResources;
import edu.colorado.phet.quantumwaveinterference.modules.intensity.IntensityBeamPanel;
import edu.colorado.phet.quantumwaveinterference.view.QWIPanel;
import edu.colorado.phet.quantumwaveinterference.view.piccolo.detectorscreen.DetectorSheetPNode;
import edu.colorado.phet.quantumwaveinterference.view.piccolo.detectorscreen.SavedScreenGraphic;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DetectorSheetControlPanel
extends VerticalLayoutPanel {
    private JButton clearButton;
    private DetectorSheetPNode detectorSheetPNode;
    private JButton saveScreenJButton;
    private ModelSlider brightnessModelSlider;
    private JCheckBox fadeCheckbox;
    private HorizontalLayoutPanel displayPanel;

    public DetectorSheetControlPanel(final DetectorSheetPNode detectorSheetPNode) {
        this.detectorSheetPNode = detectorSheetPNode;
        this.clearButton = new JButton(QWIResources.getString("screen.clear"));
        this.clearButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                detectorSheetPNode.reset();
            }
        });
        this.saveScreenJButton = new JButton(QWIResources.getString("screen.copy"));
        this.saveScreenJButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BufferedImage bufferedImage = detectorSheetPNode.copyScreen();
                SavedScreenGraphic savedScreenGraphic = new SavedScreenGraphic(DetectorSheetControlPanel.this.getSchrodingerPanel(), bufferedImage);
                savedScreenGraphic.setOffset(130.0, 130.0);
                DetectorSheetControlPanel.this.getSchrodingerPanel().getSchrodingerScreenNode().addSavedScreenGraphic(savedScreenGraphic);
            }
        });
        this.brightnessModelSlider = new ModelSlider(QWIResources.getString("screen.brightness"), "", 0.0, 1.0, this.getBrightess(), new DecimalFormat("0.0"));
        detectorSheetPNode.addListener(new DetectorSheetPNode.Listener(){

            public void brightnessChanged() {
                DetectorSheetControlPanel.this.brightnessModelSlider.setValue(DetectorSheetControlPanel.this.getBrightess());
            }
        });
        this.brightnessModelSlider.setTextFieldVisible(false);
        this.brightnessModelSlider.setModelTicks(new double[]{0.0, 0.5, 1.0});
        this.brightnessModelSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                DetectorSheetControlPanel.this.setBrightness();
            }
        });
        this.setBrightness();
        this.fadeCheckbox = new JCheckBox(QWIResources.getString("screen.fade"), this.getSchrodingerPanel().isFadeEnabled());
        this.fadeCheckbox.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                DetectorSheetControlPanel.this.getSchrodingerPanel().setFadeEnabled(DetectorSheetControlPanel.this.fadeCheckbox.isSelected());
            }
        });
        this.getSchrodingerPanel().addListener(new QWIPanel.Adapter(){

            public void fadeStateChanged() {
                DetectorSheetControlPanel.this.fadeCheckbox.setSelected(DetectorSheetControlPanel.this.getSchrodingerPanel().isFadeEnabled());
            }
        });
        this.displayPanel = new HorizontalLayoutPanel();
        this.displayPanel.setBorder(BorderFactory.createTitledBorder(QWIResources.getString("screen.display")));
        ButtonGroup buttonGroup = new ButtonGroup();
        JRadioButton jRadioButton = new JRadioButton(QWIResources.getString("screen.hits"), false);
        JRadioButton jRadioButton2 = new JRadioButton(QWIResources.getString("screen.intensity"), true);
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
        jRadioButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DetectorSheetControlPanel.this.setContinuousDisplay(false);
            }
        });
        jRadioButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DetectorSheetControlPanel.this.setContinuousDisplay(true);
            }
        });
        this.displayPanel.add(jRadioButton2);
        this.displayPanel.add(jRadioButton);
        HorizontalLayoutPanel horizontalLayoutPanel = new HorizontalLayoutPanel();
        horizontalLayoutPanel.setBorder(BorderFactory.createTitledBorder(QWIResources.getString("screen.title")));
        horizontalLayoutPanel.add(this.fadeCheckbox);
        horizontalLayoutPanel.add(this.clearButton);
        horizontalLayoutPanel.add(this.saveScreenJButton);
        this.add(horizontalLayoutPanel);
        this.add(this.brightnessModelSlider);
        this.add(this.displayPanel);
    }

    private double getBrightess() {
        return this.detectorSheetPNode.getBrightness();
    }

    public void setBrightness() {
        this.detectorSheetPNode.setBrightness(this.brightnessModelSlider.getValue());
        if (this.getIntensityPanel() != null && this.getIntensityPanel().getContinuousDisplay() != null) {
            this.getIntensityPanel().getContinuousDisplay().setBrightness(this.brightnessModelSlider.getValue());
        }
    }

    private void setContinuousDisplay(boolean bl) {
        if (this.getIntensityPanel() != null) {
            this.getIntensityPanel().setContinuousMode(bl);
        }
    }

    private IntensityBeamPanel getIntensityPanel() {
        if (this.detectorSheetPNode.getSchrodingerPanel() instanceof IntensityBeamPanel) {
            return (IntensityBeamPanel)this.detectorSheetPNode.getSchrodingerPanel();
        }
        return null;
    }

    private QWIPanel getSchrodingerPanel() {
        return this.detectorSheetPNode.getSchrodingerPanel();
    }

    public void setClearButtonVisible(boolean bl) {
        this.clearButton.setEnabled(bl);
    }

    public void setSaveButtonVisible(boolean bl) {
        this.saveScreenJButton.setVisible(bl);
        this.supervalidate();
    }

    public void setBrightnessSliderVisible(boolean bl) {
        this.brightnessModelSlider.setVisible(bl);
    }

    public void setFadeCheckBoxVisible(boolean bl) {
        this.fadeCheckbox.setVisible(bl);
    }

    private void supervalidate() {
        this.validate();
    }

    public void setTypeControlVisible(boolean bl) {
        this.displayPanel.setVisible(bl);
        this.supervalidate();
    }
}

