/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.quantumwaveinterference;

import edu.colorado.phet.common.phetcommon.application.ApplicationConstructor;
import edu.colorado.phet.common.phetcommon.application.Module;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationConfig;
import edu.colorado.phet.common.phetcommon.application.PhetApplicationLauncher;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetcommon.model.clock.SwingClock;
import edu.colorado.phet.common.piccolophet.PiccoloPhetApplication;
import edu.colorado.phet.common.piccolophet.TabbedModulePanePiccolo;
import edu.colorado.phet.common.piccolophet.help.MotionHelpBalloon;
import edu.colorado.phet.quantumwaveinterference.QWIFrameSetup;
import edu.colorado.phet.quantumwaveinterference.QWIModule;
import edu.colorado.phet.quantumwaveinterference.QWIPhetLookAndFeel;
import edu.colorado.phet.quantumwaveinterference.QWIResources;
import edu.colorado.phet.quantumwaveinterference.modules.intensity.IntensityModule;
import edu.colorado.phet.quantumwaveinterference.modules.mandel.MandelModule;
import edu.colorado.phet.quantumwaveinterference.modules.single.SingleParticleModule;
import edu.colorado.phet.quantumwaveinterference.persistence.PersistenceManager;
import edu.colorado.phet.quantumwaveinterference.persistence.QWIState;
import edu.colorado.phet.quantumwaveinterference.view.QWIPanel;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.jnlp.UnavailableServiceException;
import javax.swing.JMenuItem;

public class QuantumWaveInterferenceApplication
extends PiccoloPhetApplication {
    private IntensityModule intensityModule = new IntensityModule(this, QuantumWaveInterferenceApplication.createClock());
    private SingleParticleModule singleParticleModule;
    private MandelModule mandelModule;

    public QuantumWaveInterferenceApplication(PhetApplicationConfig phetApplicationConfig) {
        super(phetApplicationConfig, new QWTTabbedModulePane());
        this.addModule(this.intensityModule);
        this.singleParticleModule = new SingleParticleModule(this, QuantumWaveInterferenceApplication.createClock());
        this.addModule(this.singleParticleModule);
        this.mandelModule = new MandelModule(this, QuantumWaveInterferenceApplication.createClock());
        this.addModule(this.mandelModule);
        JMenuItem jMenuItem = new JMenuItem(QWIResources.getString("menus.save"));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                QWIModule qWIModule = QuantumWaveInterferenceApplication.this.getActiveSchrodingerModule();
                new PersistenceManager(qWIModule.getSchrodingerPanel()).save(new QWIState(qWIModule));
            }
        });
        this.getPhetFrame().addFileMenuItem(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem(QWIResources.getString("menus.load"));
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    QWIModule qWIModule = QuantumWaveInterferenceApplication.this.getActiveSchrodingerModule();
                    QWIState qWIState = (QWIState)new PersistenceManager(qWIModule.getSchrodingerPanel()).load();
                    qWIState.restore(qWIModule);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                catch (UnavailableServiceException unavailableServiceException) {
                    unavailableServiceException.printStackTrace();
                }
            }
        });
        this.getPhetFrame().addFileMenuItem(jMenuItem2);
        this.getPhetFrame().addFileMenuSeparator();
    }

    public void startApplication() {
        super.startApplication();
        if (this.intensityModule != null) {
            this.addWiggleMe();
        }
    }

    private QWIModule getActiveSchrodingerModule() {
        return (QWIModule)this.getActiveModule();
    }

    private static IClock createClock() {
        return new SwingClock(30, 1.0);
    }

    public IntensityModule getIntensityModule() {
        return this.intensityModule;
    }

    public SingleParticleModule getSingleParticleModule() {
        return this.singleParticleModule;
    }

    public MandelModule getMandelModule() {
        return this.mandelModule;
    }

    private void addWiggleMe() {
        QWIPanel qWIPanel = this.intensityModule.getSchrodingerPanel();
        final MotionHelpBalloon motionHelpBalloon = new MotionHelpBalloon(qWIPanel, QWIResources.getString("qwi.invitation"));
        motionHelpBalloon.setTextColor(Color.white);
        motionHelpBalloon.setShadowTextColor(Color.gray);
        motionHelpBalloon.setShadowTextOffset(1.0);
        motionHelpBalloon.setBalloonVisible(true);
        motionHelpBalloon.setBalloonFillPaint(new Color(128, 128, 128, 200));
        qWIPanel.getSchrodingerScreenNode().addChild(motionHelpBalloon);
        motionHelpBalloon.animateTo(qWIPanel.getSchrodingerScreenNode().getGunGraphic());
        qWIPanel.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                motionHelpBalloon.setVisible(false);
            }
        });
    }

    public static void main(String[] stringArray) {
        ApplicationConstructor applicationConstructor = new ApplicationConstructor(){

            public PhetApplication getApplication(PhetApplicationConfig phetApplicationConfig) {
                return new QuantumWaveInterferenceApplication(phetApplicationConfig);
            }
        };
        PhetApplicationConfig phetApplicationConfig = new PhetApplicationConfig(stringArray, "quantum-wave-interference", "quantum-wave-interference");
        phetApplicationConfig.setLookAndFeel(new QWIPhetLookAndFeel());
        phetApplicationConfig.setFrameSetup(new QWIFrameSetup());
        new PhetApplicationLauncher().launchSim(phetApplicationConfig, applicationConstructor);
    }

    private static class QWTTabbedModulePane
    extends TabbedModulePanePiccolo {
        private QWTTabbedModulePane() {
        }

        public void addTab(Module module) {
            super.addTab("<html>" + module.getName() + "</html>", module.getModulePanel());
        }
    }
}

