/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.view.clock;

import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.ClockListener;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.util.EventChannel;
import edu.colorado.phet.common.phetcommon.view.util.SwingUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.EventListener;
import java.util.EventObject;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class StopwatchPanel
extends JPanel {
    private static final Color DEFAULT_BACKGROUND = new Color(237, 225, 113);
    private static final NumberFormat DEFAULT_FORMAT = new DecimalFormat("0.00");
    private IClock clock;
    private String startString;
    private String stopString;
    private JButton startStopButton;
    private JButton resetButton;
    private JTextField timeDisplay;
    private NumberFormat timeFormat;
    private JLabel timeUnitsLabel;
    private double scaleFactor;
    private double runningTime;
    private boolean isRunning;
    private boolean resetEnabledWhileRunning;
    ClockListener clockListener;
    private EventChannel stopwatchEventChannel;
    private StopwatchListener stopwatchListenerProxy;

    public StopwatchPanel(IClock iClock, String string, double d, NumberFormat numberFormat) {
        this.setBackground(DEFAULT_BACKGROUND);
        this.setBorder(BorderFactory.createRaisedBevelBorder());
        this.clock = iClock;
        this.scaleFactor = d;
        this.timeFormat = numberFormat;
        this.startString = PhetCommonResources.getInstance().getLocalizedString("Common.StopwatchPanel.start");
        this.stopString = PhetCommonResources.getInstance().getLocalizedString("Common.StopwatchPanel.stop");
        this.startStopButton = new JButton(this.startString);
        SwingUtils.fixButtonOpacity(this.startStopButton);
        this.resetButton = new JButton(PhetCommonResources.getInstance().getLocalizedString("Common.StopwatchPanel.reset"));
        SwingUtils.fixButtonOpacity(this.resetButton);
        this.timeDisplay = new JTextField(5);
        Font font = this.timeDisplay.getFont();
        this.timeDisplay.setFont(new Font(font.getName(), 1, 16));
        this.timeDisplay.setEditable(false);
        this.timeDisplay.setHorizontalAlignment(4);
        this.timeUnitsLabel = new JLabel(string);
        this.setLayout(new FlowLayout());
        this.add(this.startStopButton);
        this.add(this.resetButton);
        this.add(this.timeDisplay);
        this.add(this.timeUnitsLabel);
        this.resizeButtons();
        StopwatchButtonListener stopwatchButtonListener = new StopwatchButtonListener();
        this.startStopButton.addActionListener(stopwatchButtonListener);
        this.resetButton.addActionListener(stopwatchButtonListener);
        this.clockListener = new StopwatchClockListener();
        iClock.addClockListener(this.clockListener);
        this.stopwatchEventChannel = new EventChannel(StopwatchListener.class);
        this.stopwatchListenerProxy = (StopwatchListener)this.stopwatchEventChannel.getListenerProxy();
        this.runningTime = 0.0;
        this.isRunning = false;
        this.resetEnabledWhileRunning = true;
        this.updateButtons();
        this.updateTimeDisplay();
    }

    public void start() {
        if (!this.isRunning) {
            this.isRunning = true;
            this.updateButtons();
            this.stopwatchListenerProxy.start(new StopwatchEvent(this));
        }
    }

    public void stop() {
        if (this.isRunning) {
            this.isRunning = false;
            this.updateButtons();
            this.stopwatchListenerProxy.stop(new StopwatchEvent(this));
        }
    }

    public void reset() {
        if (!this.isReset()) {
            this.runningTime = 0.0;
            this.updateTimeDisplay();
            this.updateButtons();
            this.stopwatchListenerProxy.reset(new StopwatchEvent(this));
        }
    }

    public JTextField getTimeDisplay() {
        return this.timeDisplay;
    }

    public void setTimeUnits(String string) {
        this.timeUnitsLabel.setText(string);
    }

    public void setScaleFactor(double d) {
        this.scaleFactor = d;
        this.updateTimeDisplay();
    }

    public void setTimeFormat(NumberFormat numberFormat) {
        this.timeFormat = numberFormat;
        this.updateTimeDisplay();
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public boolean isReset() {
        return this.runningTime == 0.0;
    }

    private void resizeButtons() {
        String string = this.startStopButton.getText();
        this.startStopButton.setText(this.stopString);
        Dimension dimension = this.startStopButton.getPreferredSize();
        this.startStopButton.setText(this.startString);
        Dimension dimension2 = this.startStopButton.getPreferredSize();
        Dimension dimension3 = new Dimension(Math.max(dimension.width, dimension2.width), Math.max(dimension.height, dimension2.height));
        this.startStopButton.setPreferredSize(dimension3);
        this.startStopButton.setText(string);
    }

    private void updateTimeDisplay() {
        String string = this.timeFormat.format(this.runningTime * this.scaleFactor);
        this.timeDisplay.setText(string);
    }

    private void updateButtons() {
        if (this.isRunning) {
            this.startStopButton.setText(this.stopString);
        } else {
            this.startStopButton.setText(this.startString);
        }
        this.resetButton.setEnabled(this.resetEnabledWhileRunning || !this.isRunning);
    }

    private class StopwatchButtonListener
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == StopwatchPanel.this.startStopButton) {
                if (StopwatchPanel.this.isRunning()) {
                    StopwatchPanel.this.stop();
                } else {
                    StopwatchPanel.this.start();
                }
            } else if (actionEvent.getSource() == StopwatchPanel.this.resetButton) {
                StopwatchPanel.this.reset();
            }
        }
    }

    private class StopwatchClockListener
    extends ClockAdapter {
        public void clockTicked(ClockEvent clockEvent) {
            if (StopwatchPanel.this.isRunning) {
                StopwatchPanel.this.runningTime += clockEvent.getSimulationTimeChange();
                StopwatchPanel.this.updateTimeDisplay();
            }
        }
    }

    public class StopwatchEvent
    extends EventObject {
        public StopwatchEvent(Object object) {
            super(object);
        }
    }

    public static interface StopwatchListener
    extends EventListener {
        public void start(StopwatchEvent var1);

        public void stop(StopwatchEvent var1);

        public void reset(StopwatchEvent var1);
    }
}

