/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.statistics;

import edu.colorado.phet.common.phetcommon.application.ISimInfo;
import edu.colorado.phet.common.phetcommon.application.SessionCounter;
import edu.colorado.phet.common.phetcommon.files.PhetInstallation;
import edu.colorado.phet.common.phetcommon.preferences.PhetPreferences;
import edu.colorado.phet.common.phetcommon.resources.PhetResources;
import edu.colorado.phet.common.phetcommon.statistics.StatisticsMessage;
import edu.colorado.phet.common.phetcommon.statistics.StatisticsMessageField;
import edu.colorado.phet.common.phetcommon.util.DeploymentScenario;
import edu.colorado.phet.common.phetcommon.util.JavaVersion;
import java.util.Date;

public class SessionMessage
extends StatisticsMessage {
    private static SessionMessage instance;

    public static SessionMessage initInstance(ISimInfo iSimInfo) {
        if (instance != null) {
            throw new RuntimeException("initInstance was called more than once");
        }
        instance = new SessionMessage(iSimInfo);
        return instance;
    }

    public static SessionMessage getInstance() {
        return instance;
    }

    private SessionMessage(ISimInfo iSimInfo) {
        super("session", "0");
        StatisticsMessageField[] statisticsMessageFieldArray;
        this.initTimeZone();
        JavaVersion.JREVersion jREVersion = new JavaVersion.JREVersion();
        String string = null;
        if (DeploymentScenario.getInstance() == DeploymentScenario.PHET_INSTALLATION) {
            statisticsMessageFieldArray = PhetInstallation.getInstance();
            string = String.valueOf(statisticsMessageFieldArray.getInstallationTimestamp());
        }
        statisticsMessageFieldArray = new StatisticsMessageField[]{new StatisticsMessageField("Common.statistics.sim_project", "sim_project", iSimInfo.getProjectName()), new StatisticsMessageField("Common.statistics.sim_name", "sim_name", iSimInfo.getFlavor()), new StatisticsMessageField("Common.statistics.sim_major_version", "sim_major_version", iSimInfo.getVersion().getMajor()), new StatisticsMessageField("Common.statistics.sim_minor_version", "sim_minor_version", iSimInfo.getVersion().getMinor()), new StatisticsMessageField("Common.statistics.sim_dev_version", "sim_dev_version", iSimInfo.getVersion().getDev()), new StatisticsMessageField("Common.statistics.sim_revision", "sim_revision", iSimInfo.getVersion().getRevision()), new StatisticsMessageField("Common.statistics.sim_version_timestamp", "sim_version_timestamp", iSimInfo.getVersion().getTimestampSeconds()), new StatisticsMessageField("Common.statistics.sim_distribution_tag", "sim_distribution_tag", iSimInfo.getDistributionTag()), new StatisticsMessageField("Common.statistics.sim_locale_language", "sim_locale_language", PhetResources.readLocale().getLanguage()), new StatisticsMessageField("Common.statistics.sim_locale_country", "sim_locale_country", PhetResources.readLocale().getCountry()), new StatisticsMessageField("Common.statistics.sim_deployment", "sim_deployment", DeploymentScenario.getInstance().toString()), new StatisticsMessageField("Common.statistics.sim_dev", "sim_dev", iSimInfo.isDev() + ""), new StatisticsMessageField("Common.statistics.sim_total_sessions", "sim_total_sessions", SessionCounter.getInstance().getCount()), new StatisticsMessageField("Common.statistics.sim_sessions_since", "sim_sessions_since", SessionCounter.getInstance().getCountSince()), new StatisticsMessageField.SystemProperty("Common.statistics.host_os_name", "host_os_name", "os.name"), new StatisticsMessageField.SystemProperty("Common.statistics.host_os_version", "host_os_version", "os.version"), new StatisticsMessageField.SystemProperty("Common.statistics.host_os_arch", "host_os_arch", "os.arch"), new StatisticsMessageField.SystemProperty("Common.statistics.host_java_vendor", "host_java_vendor", "java.vendor"), new StatisticsMessageField("Common.statistics.host_java_version_major", "host_java_version_major", jREVersion.getMajorNumber()), new StatisticsMessageField("Common.statistics.host_java_version_minor", "host_java_version_minor", jREVersion.getMinorNumber()), new StatisticsMessageField("Common.statistics.host_java_version_maintenance", "host_java_version_maintenance", jREVersion.getMaintenanceNumber()), new StatisticsMessageField.SystemProperty("Common.statistics.host_java_webstart_version", "host_java_webstart_version", "javawebstart.version"), new StatisticsMessageField.SystemProperty("Common.statistics.host_locale_language", "host_locale_language", "user.language"), new StatisticsMessageField.SystemProperty("Common.statistics.host_locale_country", "host_locale_country", "user.country"), new StatisticsMessageField.SystemProperty("Common.statistics.host_java_timezone", "host_java_timezone", "user.timezone"), new StatisticsMessageField("Common.statistics.user_preference_file_creation_time", "user_preference_file_creation_time", PhetPreferences.getInstance().getPreferencesFileCreationTime()), new StatisticsMessageField("Common.statistics.user_total_sessions", "user_total_sessions", SessionCounter.getInstance().getTotal()), new StatisticsMessageField("Common.statistics.user_installation_timestamp", "user_installation_timestamp", string)};
        super.addFields(statisticsMessageFieldArray);
    }

    private void initTimeZone() {
        new Date().toString();
    }
}

