function trap = init_trap(model)
% initialize physics container structure

ngauss = model.rgrid.nrhogauss;
nx = model.dims.nx;
nu = model.dims.nu;

gg      = zeros(ngauss,1);
dgg_dx  = zeros(ngauss,nx);
dgg_du  = zeros(ngauss,nu);
gn      = zeros(model.ntm.n_ntm,1);

trap = struct(...
'iota',gg,...
'diota_dx',dgg_dx,...
'q',gg,...
'dq_dx',dgg_dx,...
'shear',gg,...
'dshear_dx',dgg_dx,...
'signeo',gg,...
'dsigneo_dx',dgg_dx,...
'jbsB',gg,...
'djbsB_dx',dgg_dx,...
'Lbs',gg,...
'fbse',gg,...
'jec',gg,...
'jnb',gg,...
'jlh',gg,...
'jic',gg,...
'jreB',gg,...
'jauxB',gg,...
'djauxB_dx',dgg_dx,...
'djauxB_du',dgg_du,...
'jphioR',gg,...
'djphioR_dx',dgg_dx,...
'jdistB',gg,...
'pec',gg,...
'pnbe',gg,...
'pnbi',gg,...
'pice',gg,...
'pici',gg,...
'plh',gg,...
'pauxe',gg,...
'pauxi',gg,...
'petot',gg,...
'dpetot_dx',dgg_dx,...
'dpetot_dxdot',dgg_dx,...
'dpetot_du',dgg_du,...
'pitot',gg,...
'dpitot_dx',dgg_dx,...
'dpitot_dxdot',dgg_dx,...
'dpitot_du',dgg_du,...
'chie',gg,...
'dchie_dx',dgg_dx,...
'dchie_dxdot',dgg_dx,...
'dchie_du',dgg_du,...
'chii',gg,...
'dchii_dx',dgg_dx,...
'dchii_dxdot',dgg_dx,...
'dchii_du',dgg_du,...
'dne',gg,...
'ddne_dx',dgg_dx,...
'ddne_dxdot',dgg_dx,... 
'ddne_du',dgg_du,...
'vne',gg,...
'dvne_dx',dgg_dx,...
'dvne_dxdot',dgg_dx,... 
'dvne_du',dgg_du,...
'Gammae', gg, ...
'dGammae_dx', dgg_dx, ...
'dGammae_dxdot', dgg_dx, ...
'dGammae_du', dgg_du, ...
'sne',gg,...
'dsne_dx',dgg_dx,...
'dsne_dxdot',dgg_dx,... 
'dsne_du',dgg_du,...
'poh',gg,...
'palphae',gg,...
'palphai',gg,...
'pbrem',gg,...
'pei',gg,...
'prad',gg,...
'pdist',gg,...
'pfast',gg,...
'pfastnb',gg,...
'pfastic',gg,...
'dwntmdt',gn...
);