function isRequired = derivative_is_required(channel,model)
% inform whether derivative with respect to a given channel is required

switch channel
    case 'te'
        isRequired = strcmp(model.te.method,'state') ...
                      || strcmp(model.te.method,'tiscal') && strcmp(model.ti.method,'state');
    case 'ti'
        isRequired = strcmp(model.ti.method,'state') ...
                      || strcmp(model.ti.method,'tescal') && strcmp(model.te.method,'state');
    case 'ni'
        isRequired = strcmp(model.ne.method,'state') && (strcmp(model.ni.method,'nescal') || strcmp(model.ni.method,'qnze')) ...
                || strcmp(model.ni.method,'state');
    case 'ne'
        isRequired = strcmp(model.ni.method,'state') && (strcmp(model.ne.method,'niscal') || strcmp(model.ne.method,'qnze')) ...
         || strcmp(model.ne.method,'state'); 
    case 'ze'
        isRequired = strcmp(model.ze.method,'qnze');
    otherwise
        error('not implemented yet')
end