function err = calc_error(dprofa,dprofn,prof0)
% generic function to calculate calculate relative numerical vs analytical error in Jacobian
% err = ||numerical-analytical||/||analytical||

if ~isnan(dprofa)
    if norm(dprofn) == 0 && norm(dprofa) == 0
        err = 0; % zero error because no dependence
    elseif (norm(dprofn)/norm(prof0) < 10*eps) && ...
            (norm(dprofa)/norm(prof0) < 10*eps)
        err = 0; % zero because relative change is too small (but nonzero)
    elseif norm(dprofn) == 0
        err = inf; % they should not be zero while the other is nonzero
    elseif norm(dprofa) == 0
        err = -inf; % they should not be zero while the other is nonzero
    else
        err = norm(dprofn-dprofa)./(norm(dprofa)+eps); % relative error
    end
else % if Jacobian is does not exist
    if norm(dprofn) == 0
        % no dependence (numerically) and Jacobian undefined
        err = 0;
    else
        err = NaN; % numerical dependence, but no Jacobian defined!
    end
    
end
return