function hax = get_persistent_hax(hax, figname, nrow, ncol, clearaxes)
%GET_PERSISTENT_HAX get or make settings of a hax from a persistent plot
%  Assumed 'persistent hax' is put in the function prior to calling this
%  function


if isempty(hax) || ~all(all(ishandle(hax)))
  hf = findall(0,'Name',figname,'Type','figure');
  if isempty(hf) || ~ishandle(hf)
      hf = figure('Name',figname,'NumberTitle','off','handlevisibility','callback');
  end 
  clf(hf);
  hax = multiaxes(hf,ncol,nrow)';
end

for ii=1:numel(hax)
    if clearaxes
        cla(hax(ii));
    else
        hold(hax(ii),'on');
    end
end
end

