function RAPTOR_plot_iteration(x,xdot,g,v,model)
%%
psi = eval_psi(x,g,v,model,false);
q = eval_q(x,g,v,model,false);

te = eval_te(x,g,v,model,false);
ti = eval_ti(x,g,v,model,false);

ne = eval_ne(x,g,v,model,false);
ni = eval_ni(x,g,v,model,false);

rho = model.rgrid.rho;


%% plot
subplot(231);
plot(rho,psi,'-')
title('psi')
xlabel('rho')

subplot(234);
plot(rho,te,'--',rho,ti,'-')
title('Te (--), Ti')
xlabel('rho')

subplot(232);
plot(rho,q,'-')
title('q')
xlabel('rho')

subplot(233);
plot(rho,xdot(1)*ones(size(rho)),'-')
title('Upl')
xlabel('rho')

subplot(235);
plot(rho,ne,'--',rho,ni,'-')
title('ne (--), ni')
xlabel('rho')


drawnow



return