%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%% Vp and Dn scaled from chi_e
function varargout = vpdn_chiescal(varargin)
% Electron diffusivity and pinch velocity

if nargin==0
  varargout{1} = 'vpdn_e'; % type
  varargout{2} = []; % empty config
return
elseif nargin == 2,
  %% DEFAULT PARAMETERS
  module_params=struct(...
    'dnochie' , 0.2,... % Dne = dnochie*chi_e: Dne linearly proportional to chi_e
    'vpodne'   , -5. ... % Vpe = vpodn*Dne: Vpe linearly proportional to Dne
    );
  mm.name = mfilename;
  varargout{1} = mm;
  varargout{2} = module_params;
  return %empty call, probably to get default structures
elseif nargin==6;
  %stap   = varargin{1};
  %geop   = varargin{2};
  trap   = varargin{3};
  %it     = varargin{4};
  %model  = varargin{5};
  vdp = varargin{6};
else
  error('must call with 0 or 6 inputs');
end

chie = trap.chie;

% Dne: from chi_e
Dne = vdp.dnochie*chie;
% Vne: from Dne
Vpe = vdp.vpodne*Dne;

varargout{1} = Dne;
varargout{2} = Vpe;
end