%% Fraction Of Energy To Ions/Electrons
% The fraction of the energy that is deposited to the ions resp. electrons
% is calculated in J. Wesson: Tokamaks. The fraction to the ions is given
% by $\phi (x) = \frac{1}{x}(\frac{1}{3}\log\frac{1-x^{1/2}+x}{(1+x^{1/2})^{2}} + 
% \frac{2}{\sqrt{3}}(atan\frac{2x^{1/2}-1}{\sqrt{3}+\frac{\pi}{6}))$. Where
% x is given by E_{b0}/E_{c}:
% Syntax: 
%   [phi] = fastionenergyfraction(x)           or 
%   [phi, dphi_dx] = fastionenergyfraction(x)
% where x = E_beam / E_crit. Be cautious with using x as a variable since
% it is already used by RAPTOR as the variable for the plasma state.


function varargout = fastionenergyfraction(x)

x12     =   x.^(1/2);               % precalculated for efficiency
phi     =   (1./x).*((log((1- x12 + x)./((1 + x12).^2))./3)...
    + (2./sqrt(3)).*(atan((2*x12-1)/sqrt(3))+ pi./6));
varargout{1} = phi;

if nargout==2
    dphi_dx =   1./(x+x.^(5/2)) - phi./x;
    varargout{2} = dphi_dx;
end

if nargout>2
    error('Too many output parameters requested')
end