function chi = chi_central(model,cp)

assert(isfield(cp,'chi_ccentral'),'chi_ccentral not defined');
assert(isfield(cp,'chi_wcentral'),'chi_wcentral not defined');

if cp.chi_ccentral ~= 0
    chi = cp.chi_ccentral*exp(-model.rgrid.rhogauss.^2/(cp.chi_wcentral.^2));
else
    % must define on all execution paths
    chi = ones(model.rgrid.nrhogauss,1);
end

end
  
