function QLKNNparams = appendRAPTORInterfaceParameters4D(QLKNNparams)
coreChie = 2; coreChii = 2;
edgeChie = 2; edgeChii = 2;

minChie = 0.1; minChii = 0.1;
maxChie = 100; maxChii = 100;

minDe = 0.0500; minVe = -100;
maxDe = 100; maxVe = 100;

coreDe = 2; coreVe = -0.2;
edgeDe = 5; edgeVe = -1;

% set param structure
QLKNNparams.implicit = true;

QLKNNparams.doplot = false;

QLKNNparams.edgeStyle = 'constant';
QLKNNparams.rhocore = 0.3;
QLKNNparams.rhoedge = 0.8;
QLKNNparams.coreValues = [coreChie, coreChii, coreDe, coreVe];
QLKNNparams.edgeValues = [edgeChie, edgeChii, edgeDe, edgeVe];
QLKNNparams.maxTCoeff = [maxChie maxChii maxDe maxVe];
QLKNNparams.minTCoeff = [minChie minChii minDe minVe];

QLKNNparams.edgeStyle = 'interpolate';
QLKNNparams.coreStyle = 'interpolate';

QLKNNparams.outSmoothing = 0.3;

return
