%function RAPTOR_imas_write(out,model,shot_number,run_number)

%% -------------------------------------------------
%% Purpose: fill IDSs from RAPTOR output structure
%% for its adaptation to IMAS
%% -------------------------------------------------
%% Involved output IDSs:
%% - equilibrium
%% - core_profiles
%% - core_transport
%% - summary
%% - core_sources
%% - sawteeth
%% - ntms
%% - distributions
%% -------------------------------------------------
%% Note: RAPTOR has cocos = 12, with B0>0
%% -------------------------------------------------

%% Temporary
shot_number = 88;
run_number  = 1;

%% Time vector
time  = out.time;
ntime = out.ntime;

%% Normalized toroidal flux coordinate vector
rho  = out.rho;
nrho = out.nrho;

%% General code information
code.name = 'RAPTOR';
code.version = 'Not implemented yet';
code.parameters = 'Not implemented yet';

%% ----------
%% FILL IDSs
%% ----------
core_profiles = RAPTOR_idsfill_core_profiles(out,model,code);
distributions = RAPTOR_idsfill_distributions(out,code);
sawteeth      = RAPTOR_idsfill_sawteeth(out,model,code);
%% to add: core_sources, core_transport

%% FILL THE PULSE_SCHEDULE IDS

%% Write IDSs to local database
idx = imas_create('ids',shot_number,run_number);
ids_put(idx,'core_profiles',core_profiles)
ids_put(idx,'distributions',distributions)
ids_put(idx,'sawteeth',sawteeth)
imas_close(idx);


