%% % sawtooth module
function varargout = porcelli(varargin)

if nargin == 0,
    module_params = struct(...
        's1crit', 0.1,... %critical shear
        'mode', 0, ...%reconnection model: 0 full, 1 incomplete
        'w_norm', 0.5,...
        'reconnect_q', true,... % switch whether to reconnect q or not
        'reconnect_te',true,...% switch whether to reconnect Te or not
        'reconnect_ti',true,... % switch whether to reconnect ne or not
        'reconnect_ne',true,... % switch whether to reconnect ne or not
        'reconnect_ni',true,... % switch whether to reconnect ne or not
        'active',true,...
        'check',false); 
    varargout{1} = module_params;
    return %empty call, probably to get default structures
elseif nargin==7;
    x = varargin{1};
    g = varargin{2};
    v = varargin{3};
    u = varargin{4};
    it = varargin{5};
    model  = varargin{6};
    saw_params = varargin{7}; % distribute inputs
else
    error('must call with 0 or 7 inputs');
end

xnew = x; % init;

% check whether it satisfies sawtooth criteria
icrash = saw_criteria(x, g, v, u, it, model, saw_params);

if icrash == 4
    switch saw_params.mode
         case 0 % full reconnection 
             xnew = saw_full(x, g, v, u, it, model, saw_params);
         case 1 % incomplete reconnection
             error('not supported any more')
             xnew = saw_incom(x, g, v, u, it, model, saw_params); 
    end
end
varargout{1} = xnew;
return
