function [S, Sp, Spp] = splineval_hmode(rho, xkts, sporder)
% Creation of an alternative spline basis used for H modes with an imposed
% pedestal
% A spline basis of order sporder is contructed on knot points xkts
% note: rhoped = xkts(end)
% Two linear splines are constructed on [rhoped, 1], one of which is a
% continuation of the outermost spline on [0, rhoped]
rhoped = xkts(end);
xkts_ped = [rhoped; 1];
irhoped = (rho>rhoped);

[S_core, Sp_core, Spp_core] = splineval(rho, xkts, sporder, [1 0 0]);

[S_ped, Sp_ped] = splineval(rho, xkts_ped, 1);
nsp = size(S_core, 1)+1;
nrho = numel(rho);
S = zeros(nsp, nrho); Sp = S; Spp = S;

S(1:end-1, :) =  S_core;
S(end-1, irhoped) = S_ped(1, irhoped);
S(end, :) = S_ped(2, :);

Sp(1:end-1, :) =  Sp_core;
Sp(end-1, irhoped) = Sp_ped(1, irhoped);
Sp(end, :) = Sp_ped(2, :);

Spp(1:end-1, :) =  Spp_core;
end